/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.ResultSet;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class BeamSqlEnvTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testCreateExternalTableInNestedTableProvider() throws Exception {
        TestTableProvider root = new TestTableProvider();
        TestTableProvider nested = new TestTableProvider();
        TestTableProvider anotherOne = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.builder((TableProvider)root).addSchema("nested", (TableProvider)nested).addSchema("anotherOne", (TableProvider)anotherOne).build();
        JdbcConnection connection = env.connection;
        connection.createStatement().execute("CREATE EXTERNAL TABLE nested.person (id INT) TYPE test");
        connection.createStatement().execute("INSERT INTO nested.person(id) VALUES (1), (2), (6)");
        ResultSet rs = connection.createStatement().executeQuery("SELECT SUM(id) FROM nested.person");
        rs.next();
        Assert.assertEquals((long)9L, (long)rs.getInt(1));
    }

    @Test
    public void testPlannerClassNotFound() {
        this.exceptions.expect(RuntimeException.class);
        this.exceptions.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"org.test.ClassNotFound")));
        TestTableProvider root = new TestTableProvider();
        BeamSqlEnv.builder((TableProvider)root).setQueryPlannerClassName("org.test.ClassNotFound").build();
    }
}

