/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlMapTest {
    private static final Schema INPUT_ROW_TYPE = Schema.builder().addInt32Field("f_int").addMapField("f_intStringMap", Schema.FieldType.STRING, Schema.FieldType.INT32).build();
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testSelectAll() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_int").addNullableField("f_map", Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.INT32)).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_int, f_intStringMap as f_map FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{1, ImmutableMap.of((Object)"key11", (Object)11, (Object)"key22", (Object)22)}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{2, ImmutableMap.of((Object)"key33", (Object)33, (Object)"key44", (Object)44, (Object)"key55", (Object)55)}).build()});
        this.pipeline.run();
    }

    @Test
    public void testSelectMapField() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_int").addMapField("f_intStringMap", Schema.FieldType.STRING, Schema.FieldType.INT32).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT 42, MAP['aa', 1] as `f_map` FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{42, ImmutableMap.of((Object)"aa", (Object)1)}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{42, ImmutableMap.of((Object)"aa", (Object)1)}).build()});
        this.pipeline.run();
    }

    @Test
    public void testSelectMapFieldKeyValueSameType() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addInt32Field("f_int").addMapField("f_intStringMap", Schema.FieldType.STRING, Schema.FieldType.STRING).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT 42, MAP['aa', '1'] as `f_map` FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{42, ImmutableMap.of((Object)"aa", (Object)"1")}).build(), Row.withSchema((Schema)resultType).addValues(new Object[]{42, ImmutableMap.of((Object)"aa", (Object)"1")}).build()});
        this.pipeline.run();
    }

    @Test
    public void testAccessMapElement() {
        PCollection<Row> input = this.pCollectionOf2Elements();
        Schema resultType = Schema.builder().addNullableField("f_mapElem", Schema.FieldType.INT32).build();
        PCollection result = (PCollection)input.apply("sqlQuery", (PTransform)SqlTransform.query((String)"SELECT f_intStringMap['key11'] FROM PCOLLECTION"));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)resultType).addValues(new Object[]{11}).build(), Row.withSchema((Schema)resultType).addValue(null).build()});
        this.pipeline.run();
    }

    private PCollection<Row> pCollectionOf2Elements() {
        return (PCollection)this.pipeline.apply("boundedInput1", (PTransform)Create.of((Object)Row.withSchema((Schema)INPUT_ROW_TYPE).addValues(new Object[]{1}).addValue((Object)ImmutableMap.of((Object)"key11", (Object)11, (Object)"key22", (Object)22)).build(), (Object[])new Row[]{Row.withSchema((Schema)INPUT_ROW_TYPE).addValues(new Object[]{2}).addValue((Object)ImmutableMap.of((Object)"key33", (Object)33, (Object)"key44", (Object)44, (Object)"key55", (Object)55)).build()}).withSchema(INPUT_ROW_TYPE, SerializableFunctions.identity(), SerializableFunctions.identity()));
    }
}

