/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import com.google.auto.value.AutoValue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.AutoValue_BeamSqlDslSqlStdOperatorsTest_SqlOperatorId;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdk.extensions.sql.utils.DateTimeUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Ordering;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSqlDslSqlStdOperatorsTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    private static final BigDecimal ZERO = BigDecimal.valueOf(0.0);
    private static final BigDecimal ONE = BigDecimal.valueOf(1.0);
    private static final BigDecimal ONE2 = BigDecimal.valueOf(1.0).multiply(BigDecimal.valueOf(1.0));
    private static final BigDecimal ONE10 = BigDecimal.ONE.divide(BigDecimal.ONE, 10, RoundingMode.HALF_EVEN);
    private static final BigDecimal TWO = BigDecimal.valueOf(2.0);
    private static final BigDecimal TWO0 = BigDecimal.ONE.add(BigDecimal.ONE);
    private static final int INTEGER_VALUE = 1;
    private static final long LONG_VALUE = 1L;
    private static final short SHORT_VALUE = 1;
    private static final byte BYTE_VALUE = 1;
    private static final double DOUBLE_VALUE = 1.0;
    private static final float FLOAT_VALUE = 1.0f;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final List<SqlOperatorId> NON_ROW_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.ELEMENT_SLICE, (Object)SqlStdOperatorTable.EXCEPT, (Object)SqlStdOperatorTable.EXCEPT_ALL, (Object)SqlStdOperatorTable.INTERSECT, (Object)SqlStdOperatorTable.INTERSECT_ALL, (Object)SqlStdOperatorTable.LITERAL_CHAIN, (Object)SqlStdOperatorTable.PATTERN_CONCAT, (Object)SqlStdOperatorTable.UNION, (Object)SqlStdOperatorTable.UNION_ALL).stream().map(op -> BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(op)).collect(Collectors.toList());
    private final Comparator<SqlOperatorId> orderByNameThenKind = Ordering.compound((Iterable)ImmutableList.of(Comparator.comparing(operator -> operator.name()), Comparator.comparing(operator -> operator.kind())));

    private static SqlOperatorId sqlOperatorId(String nameAndKind) {
        return BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(nameAndKind, SqlKind.valueOf(nameAndKind));
    }

    private static SqlOperatorId sqlOperatorId(String name, SqlKind kind) {
        return new AutoValue_BeamSqlDslSqlStdOperatorsTest_SqlOperatorId(name, kind);
    }

    private static SqlOperatorId sqlOperatorId(SqlOperatorTest annotation) {
        return BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(annotation.name(), SqlKind.valueOf(annotation.kind()));
    }

    private static SqlOperatorId sqlOperatorId(SqlOperator sqlOperator) {
        return BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(sqlOperator.getName(), sqlOperator.getKind());
    }

    private Set<SqlOperatorId> getTestedOperators() {
        HashSet<SqlOperatorId> testedOperators = new HashSet<SqlOperatorId>();
        for (Method method : this.getClass().getMethods()) {
            testedOperators.addAll(Arrays.stream((SqlOperatorTest[])method.getAnnotationsByType(SqlOperatorTest.class)).map(annotation -> BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(annotation)).collect(Collectors.toList()));
        }
        return testedOperators;
    }

    private Set<SqlOperatorId> getDeclaredOperators() {
        HashSet<SqlOperatorId> declaredOperators = new HashSet<SqlOperatorId>();
        declaredOperators.addAll(SqlStdOperatorTable.instance().getOperatorList().stream().map(operator -> BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(operator.getName(), operator.getKind())).collect(Collectors.toList()));
        return declaredOperators;
    }

    @Test
    @SqlOperatorTest(name="CARDINALITY", kind="OTHER_FUNCTION")
    public void testAnnotationEquality() throws Exception {
        Method thisMethod = this.getClass().getMethod("testAnnotationEquality", new Class[0]);
        SqlOperatorTest sqlOperatorTest = ((SqlOperatorTest[])thisMethod.getAnnotationsByType(SqlOperatorTest.class))[0];
        Assert.assertThat((Object)BeamSqlDslSqlStdOperatorsTest.sqlOperatorId(sqlOperatorTest), (Matcher)Matchers.equalTo((Object)BeamSqlDslSqlStdOperatorsTest.sqlOperatorId("CARDINALITY", SqlKind.OTHER_FUNCTION)));
    }

    @Ignore(value="https://issues.apache.org/jira/browse/BEAM-4573")
    @Test
    public void testThatAllOperatorsAreTested() {
        HashSet<SqlOperatorId> untestedOperators = new HashSet<SqlOperatorId>();
        untestedOperators.addAll(this.getDeclaredOperators());
        untestedOperators.removeAll(NON_ROW_OPERATORS);
        untestedOperators.removeAll(this.getTestedOperators());
        if (!untestedOperators.isEmpty()) {
            ArrayList untestedList = Lists.newArrayList(untestedOperators);
            untestedList.sort(this.orderByNameThenKind);
            Assert.fail((String)String.format("No tests declared for %s operators:\n\t%s", untestedList.size(), Joiner.on((String)"\n\t").join((Iterable)untestedList)));
        }
    }

    @Test
    public void testThatOperatorsExist() {
        HashSet<SqlOperatorId> undeclaredOperators = new HashSet<SqlOperatorId>();
        undeclaredOperators.addAll(this.getTestedOperators());
        undeclaredOperators.removeAll(this.getDeclaredOperators());
        if (!undeclaredOperators.isEmpty()) {
            ArrayList undeclaredList = Lists.newArrayList(undeclaredOperators);
            undeclaredList.sort(this.orderByNameThenKind);
            Assert.fail((String)("Tests declared for nonexistent operators:\n\t" + Joiner.on((String)"\n\t").join((Iterable)undeclaredList)));
        }
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="OR", kind="OR"), @SqlOperatorTest(name="NOT", kind="NOT"), @SqlOperatorTest(name="AND", kind="AND")})
    public void testLogicOperators() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("1 = 1 AND 1 = 1", true).addExpr("1 = 1 OR 1 = 2", true).addExpr("NOT 1 = 2", true).addExpr("(NOT 1 = 2) AND (2 = 1 OR 3 = 3)", true).addExpr("2 = 2 AND 2 = 1", false).addExpr("1 = 2 OR 3 = 2", false).addExpr("NOT 1 = 1", false).addExpr("(NOT 2 = 2) AND (1 = 2 OR 2 = 3)", false).addExpr("'a' = 'a' AND 'a' = 'a'", true).addExpr("'a' = 'a' OR 'a' = 'b'", true).addExpr("NOT 'a' = 'b'", true).addExpr("(NOT 'a' = 'b') AND ('b' = 'a' OR 'c' = 'c')", true).addExpr("'b' = 'b' AND 'b' = 'a'", false).addExpr("'a' = 'b' OR 'c' = 'b'", false).addExpr("NOT 'a' = 'a'", false).addExpr("(NOT 'b' = 'b') AND ('a' = 'b' OR 'b' = 'c')", false).addExpr("1.0 = 1.0 AND 1.0 = 1.0", true).addExpr("1.0 = 1.0 OR 1.0 = 2.0", true).addExpr("NOT 1.0 = 2.0", true).addExpr("(NOT 1.0 = 2.0) AND (2.0 = 1.0 OR 3.0 = 3.0)", true).addExpr("2.0 = 2.0 AND 2.0 = 1.0", false).addExpr("1.0 = 2.0 OR 3.0 = 2.0", false).addExpr("NOT 1.0 = 1.0", false).addExpr("(NOT 2.0 = 2.0) AND (1.0 = 2.0 OR 2.0 = 3.0)", false).addExpr("NOT true", false).addExpr("NOT false", true).addExpr("true AND true", true).addExpr("true AND false", false).addExpr("false AND false", false).addExpr("true OR true", true).addExpr("true OR false", true).addExpr("false OR false", false).addExpr("(NOT false) AND (true OR false)", true).addExpr("(NOT true) AND (true OR false)", false).addExpr("(NOT false) OR (true and false)", true).addExpr("(NOT true) OR (true and false)", false);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="+", kind="PLUS"), @SqlOperatorTest(name="-", kind="MINUS"), @SqlOperatorTest(name="*", kind="TIMES"), @SqlOperatorTest(name="/", kind="DIVIDE"), @SqlOperatorTest(name="MOD", kind="MOD")})
    public void testArithmeticOperator() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("1 + 1", 2).addExpr("1.0 + 1", TWO).addExpr("1 + 1.0", TWO).addExpr("1.0 + 1.0", TWO).addExpr("c_tinyint + c_tinyint", (byte)2).addExpr("c_smallint + c_smallint", (short)2).addExpr("c_bigint + c_bigint", 2L).addExpr("c_decimal + c_decimal", TWO0).addExpr("c_tinyint + c_decimal", TWO0).addExpr("c_float + c_decimal", 2.0).addExpr("c_double + c_decimal", 2.0).addExpr("c_float + c_float", Float.valueOf(2.0f)).addExpr("c_double + c_float", 2.0).addExpr("c_double + c_double", 2.0).addExpr("c_float + c_bigint", Float.valueOf(2.0f)).addExpr("c_double + c_bigint", 2.0).addExpr("1 - 1", 0).addExpr("1.0 - 1", ZERO).addExpr("1 - 0.0", ONE).addExpr("1.0 - 1.0", ZERO).addExpr("c_tinyint - c_tinyint", (byte)0).addExpr("c_smallint - c_smallint", (short)0).addExpr("c_bigint - c_bigint", 0L).addExpr("c_decimal - c_decimal", BigDecimal.ZERO).addExpr("c_tinyint - c_decimal", BigDecimal.ZERO).addExpr("c_float - c_decimal", 0.0).addExpr("c_double - c_decimal", 0.0).addExpr("c_float - c_float", Float.valueOf(0.0f)).addExpr("c_double - c_float", 0.0).addExpr("c_double - c_double", 0.0).addExpr("c_float - c_bigint", Float.valueOf(0.0f)).addExpr("c_double - c_bigint", 0.0).addExpr("1 * 1", 1).addExpr("1.0 * 1", ONE).addExpr("1 * 1.0", ONE).addExpr("1.0 * 1.0", ONE2).addExpr("c_tinyint * c_tinyint", (byte)1).addExpr("c_smallint * c_smallint", (short)1).addExpr("c_bigint * c_bigint", 1L).addExpr("c_decimal * c_decimal", BigDecimal.ONE).addExpr("c_tinyint * c_decimal", BigDecimal.ONE).addExpr("c_float * c_decimal", 1.0).addExpr("c_double * c_decimal", 1.0).addExpr("c_float * c_float", Float.valueOf(1.0f)).addExpr("c_double * c_float", 1.0).addExpr("c_double * c_double", 1.0).addExpr("c_float * c_bigint", Float.valueOf(1.0f)).addExpr("c_double * c_bigint", 1.0).addExpr("1 / 1", 1).addExpr("1.0 / 1", ONE).addExpr("1 / 1.0", BigDecimal.ONE).addExpr("1.0 / 1.0", BigDecimal.ONE).addExpr("c_tinyint / c_tinyint", (byte)1).addExpr("c_smallint / c_smallint", (short)1).addExpr("c_bigint / c_bigint", 1L).addExpr("c_decimal / c_decimal", BigDecimal.ONE).addExpr("c_tinyint / c_decimal", BigDecimal.ONE).addExpr("c_float / c_decimal", 1.0).addExpr("c_double / c_decimal", 1.0).addExpr("c_float / c_float", Float.valueOf(1.0f)).addExpr("c_double / c_float", 1.0).addExpr("c_double / c_double", 1.0).addExpr("c_float / c_bigint", Float.valueOf(1.0f)).addExpr("c_double / c_bigint", 1.0).addExpr("mod(1, 1)", 0).addExpr("mod(1.0, 1)", 0).addExpr("mod(1, 1.0)", BigDecimal.ZERO).addExpr("mod(1.0, 1.0)", ZERO).addExpr("mod(c_tinyint, c_tinyint)", (byte)0).addExpr("mod(c_smallint, c_smallint)", (short)0).addExpr("mod(c_bigint, c_bigint)", 0L).addExpr("mod(c_decimal, c_decimal)", BigDecimal.ZERO).addExpr("mod(c_tinyint, c_decimal)", BigDecimal.ZERO).addExpr("c_tinyint_max + c_tinyint_max", (byte)-2).addExpr("c_smallint_max + c_smallint_max", (short)-2).addExpr("c_integer_max + c_integer_max", -2).addExpr("c_bigint_max + c_bigint_max", -2L);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="LIKE", kind="LIKE"), @SqlOperatorTest(name="NOT LIKE", kind="LIKE")})
    public void testLikeAndNotLike() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("'string_true_test' LIKE 'string_true_test'", true).addExpr("'string_true_test' LIKE 'string_false_test'", false).addExpr("'string_false_test' LIKE 'string_false_test'", true).addExpr("'string_false_test' LIKE 'string_true_test'", false).addExpr("'string_true_test' LIKE 'string_true_test%'", true).addExpr("'string_true_test' LIKE 'string_false_test%'", false).addExpr("'string_true_test' LIKE 'string_true%'", true).addExpr("'string_true_test' LIKE 'string_false%'", false).addExpr("'string_true_test' LIKE 'string%test'", true).addExpr("'string_true_test' LIKE '%test'", true).addExpr("'string_true_test' LIKE '%string_true_test'", true).addExpr("'string_true_test' LIKE '%string_false_test'", false).addExpr("'string_true_test' LIKE '%false_test'", false).addExpr("'string_false_test' LIKE '%false_test'", true).addExpr("'string_true_test' LIKE 'string_tr_e_test'", true).addExpr("'string_true_test' LIKE 'string______test'", true).addExpr("'string_false_test' LIKE 'string______test'", false).addExpr("'string_false_test' LIKE 'string_______test'", true).addExpr("'string_false_test' LIKE 'string_false_te__'", true).addExpr("'string_false_test' LIKE 'string_false_te___'", false).addExpr("'string_false_test' LIKE 'string_false_te_'", false).addExpr("'string_true_test' LIKE 'string_true_te__'", true).addExpr("'string_true_test' LIKE '_ring_true_te__'", false).addExpr("'string_false_test' LIKE '__ring_false_te__'", true).addExpr("'string_true_test' LIKE '_%ring_true_te__'", true).addExpr("'string_true_test' LIKE '_%tring_true_te__'", true).addExpr("'string_false_test' LIKE 'string_false_te%__'", true).addExpr("'string_false_test' LIKE 'string_false_te__%'", true).addExpr("'string_false_test' LIKE 'string_false_t%__'", true).addExpr("'string_false_test' LIKE 'string_false_t__%'", true).addExpr("'string_false_test' LIKE 'string_false_te_%'", true).addExpr("'string_false_test' LIKE 'string_false_te%_'", true).addExpr("'string_true_test' LIKE 'string_%test'", true).addExpr("'string_true_test' LIKE 'string%_test'", true).addExpr("'string_true_test' LIKE 'string_%_test'", true).addExpr("'string_true_test' NOT LIKE 'string_true_test'", false).addExpr("'string_true_test' NOT LIKE 'string_false_test'", true).addExpr("'string_false_test' NOT LIKE 'string_false_test'", false).addExpr("'string_false_test' NOT LIKE 'string_true_test'", true).addExpr("'string_true_test' NOT LIKE 'string_true_test%'", false).addExpr("'string_true_test' NOT LIKE 'string_false_test%'", true).addExpr("'string_true_test' NOT LIKE 'string_true%'", false).addExpr("'string_true_test' NOT LIKE 'string_false%'", true).addExpr("'string_true_test' NOT LIKE 'string%test'", false).addExpr("'string_true_test' NOT LIKE '%test'", false).addExpr("'string_true_test' NOT LIKE '%string_true_test'", false).addExpr("'string_true_test' NOT LIKE '%string_false_test'", true).addExpr("'string_true_test' NOT LIKE '%false_test'", true).addExpr("'string_false_test' NOT LIKE '%false_test'", false).addExpr("'string_true_test' NOT LIKE 'string_tr_e_test'", false).addExpr("'string_true_test' NOT LIKE 'string______test'", false).addExpr("'string_false_test' NOT LIKE 'string______test'", true).addExpr("'string_false_test' NOT LIKE 'string_______test'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te__'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te___'", true).addExpr("'string_false_test' NOT LIKE 'string_false_te_'", true).addExpr("'string_true_test' NOT LIKE 'string_true_te__'", false).addExpr("'string_true_test' NOT LIKE '_ring_true_te__'", true).addExpr("'string_false_test' NOT LIKE '__ring_false_te__'", false).addExpr("'string_true_test' NOT LIKE '_%ring_true_te__'", false).addExpr("'string_true_test' NOT LIKE '_%tring_true_te__'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te%__'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te__%'", false).addExpr("'string_false_test' NOT LIKE 'string_false_t%__'", false).addExpr("'string_false_test' NOT LIKE 'string_false_t__%'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te_%'", false).addExpr("'string_false_test' NOT LIKE 'string_false_te%_'", false).addExpr("'string_true_test' NOT LIKE 'string_%test'", false).addExpr("'string_true_test' NOT LIKE 'string%_test'", false).addExpr("'string_true_test' NOT LIKE 'string_%_test'", false);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="<", kind="LESS_THAN"), @SqlOperatorTest(name=">", kind="GREATER_THAN"), @SqlOperatorTest(name="<=", kind="LESS_THAN_OR_EQUAL"), @SqlOperatorTest(name="<>", kind="NOT_EQUALS"), @SqlOperatorTest(name="=", kind="EQUALS"), @SqlOperatorTest(name=">=", kind="GREATER_THAN_OR_EQUAL"), @SqlOperatorTest(name="IS NOT NULL", kind="IS_NOT_NULL"), @SqlOperatorTest(name="IS NULL", kind="IS_NULL"), @SqlOperatorTest(name="IS TRUE", kind="IS_TRUE"), @SqlOperatorTest(name="IS NOT TRUE", kind="IS_NOT_TRUE"), @SqlOperatorTest(name="IS FALSE", kind="IS_FALSE"), @SqlOperatorTest(name="IS NOT FALSE", kind="IS_NOT_FALSE"), @SqlOperatorTest(name="IS UNKNOWN", kind="IS_NULL"), @SqlOperatorTest(name="IS NOT UNKNOWN", kind="IS_NOT_NULL"), @SqlOperatorTest(name="IS DISTINCT FROM", kind="IS_DISTINCT_FROM"), @SqlOperatorTest(name="IS NOT DISTINCT FROM", kind="IS_NOT_DISTINCT_FROM")})
    public void testComparisonOperatorFunction() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("1 < 2", true).addExpr("2 < 1", false).addExpr("'a' < 'b'", true).addExpr("'b' < 'a'", false).addExpr("1.0 < 2.0", true).addExpr("2.0 < 1.0", false).addExpr("9223372036854775806 < 9223372036854775807", true).addExpr("9223372036854775807 < 9223372036854775806", false).addExpr("false < true", true).addExpr("true < false", false).addExpr("1 > 2", false).addExpr("2 > 1", true).addExpr("'a' > 'b'", false).addExpr("'b' > 'a'", true).addExpr("1.0 > 2.0", false).addExpr("2.0 > 1.0", true).addExpr("9223372036854775806 > 9223372036854775807", false).addExpr("9223372036854775807 > 9223372036854775806", true).addExpr("false > true", false).addExpr("true > false", true).addExpr("1 <> 2", true).addExpr("1 <> 1", false).addExpr("'a' <> 'b'", true).addExpr("'a' <> 'a'", false).addExpr("1.0 <> 2.0", true).addExpr("1.0 <> 1.0", false).addExpr("9223372036854775806 <> 9223372036854775807", true).addExpr("9223372036854775806 <> 9223372036854775806", false).addExpr("false <> true", true).addExpr("false <> false", false).addExpr("1 = 1", true).addExpr("2 = 1", false).addExpr("'a' = 'a'", true).addExpr("'b' = 'a'", false).addExpr("1.0 = 1.0", true).addExpr("2.0 = 1.0", false).addExpr("9223372036854775807 = 9223372036854775807", true).addExpr("9223372036854775807 = 9223372036854775806", false).addExpr("true = true", true).addExpr("true = false", false).addExpr("1 >= 2", false).addExpr("2 >= 2", true).addExpr("2 >= 1", true).addExpr("'a' >= 'b'", false).addExpr("'b' >= 'b'", true).addExpr("'b' >= 'a'", true).addExpr("1.0 >= 2.0", false).addExpr("2.0 >= 1.0", true).addExpr("2.0 >= 2.0", true).addExpr("9223372036854775806 >= 9223372036854775807", false).addExpr("9223372036854775807 >= 9223372036854775806", true).addExpr("9223372036854775807 >= 9223372036854775807", true).addExpr("false >= true", false).addExpr("true >= false", true).addExpr("true >= true", true).addExpr("1 IS NOT NULL", true).addExpr("true IS NOT NULL", true).addExpr("1.0 IS NOT NULL", true).addExpr("'a' IS NOT NULL", true).addExpr("NULL IS NOT NULL", false).addExpr("1 IS NULL", false).addExpr("true IS NULL", false).addExpr("1.0 IS NULL", false).addExpr("'a' IS NULL", false).addExpr("NULL IS NULL", true).addExpr("true IS TRUE", true).addExpr("false IS TRUE", false).addExpr("true IS NOT TRUE", false).addExpr("false IS NOT TRUE", true).addExpr("true IS FALSE", false).addExpr("false IS FALSE", true).addExpr("true IS NOT FALSE", true).addExpr("false IS NOT FALSE", false).addExpr("3 = 5 IS NOT UNKNOWN", true).addExpr("5 = 5 IS NOT UNKNOWN", true).addExpr("(NOT 5 = 5) IS NOT UNKNOWN", true).addExpr("(3 = NULL) IS UNKNOWN", true).addExpr("(3 = NULL) IS NOT UNKNOWN", false).addExpr("(NULL = NULL) IS NOT UNKNOWN", false).addExpr("(NOT NULL = NULL) IS NOT UNKNOWN", false).addExpr("1 IS DISTINCT FROM 2", true).addExpr("1.0 IS DISTINCT FROM 2.0", true).addExpr("'a' IS DISTINCT FROM 'b'", true).addExpr("true IS DISTINCT FROM false", true).addExpr("1 IS NOT DISTINCT FROM 2", false).addExpr("1.0 IS NOT DISTINCT FROM 2.0", false).addExpr("'a' IS NOT DISTINCT FROM 'b'", false).addExpr("true IS NOT DISTINCT FROM false", false).addExpr("date '2018-01-01' > DATE '2017-12-31' ", true).addExpr("date '2018-01-01' >= DATE '2017-12-31' ", true).addExpr("date '2018-01-01' < DATE '2017-12-31' ", false).addExpr("date '2018-01-01' <= DATE '2017-12-31' ", false).addExpr("date '2018-06-24' = DATE '2018-06-24' ", true).addExpr("Date '2018-06-24' <> DATE '2018-06-24' ", false).addExpr("TIME '20:17:40' < Time '15:05:57' ", false).addExpr("TIME '00:00:01' >= time '00:00:01' ", true).addExpr("TIMESTAMP '2017-12-31 23:59:59' < TIMESTAMP '2018-01-01 00:00:00' ", true);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="MAX", kind="MAX")
    public void testMax() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("MAX(c_tinyint)", (byte)3).addExpr("MAX(c_smallint)", (short)3).addExpr("MAX(c_integer)", 3).addExpr("MAX(c_bigint)", 3L).addExpr("MAX(c_float)", Float.valueOf(3.0f)).addExpr("MAX(c_double)", 3.0).addExpr("MAX(c_decimal)", BigDecimal.valueOf(3.0)).addExpr("MAX(ts)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-04-15 11:35:26"));
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="MIN", kind="MIN")
    public void testMin() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("MIN(c_tinyint)", (byte)1).addExpr("MIN(c_smallint)", (short)1).addExpr("MIN(c_integer)", 1).addExpr("MIN(c_bigint)", 1L).addExpr("MIN(c_float)", Float.valueOf(1.0f)).addExpr("MIN(c_double)", 1.0).addExpr("MIN(c_decimal)", BigDecimal.valueOf(1.0)).addExpr("MIN(ts)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:35:26"));
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="SUM", kind="SUM")
    public void testSum() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("SUM(c_tinyint)", (byte)6).addExpr("SUM(c_smallint)", (short)6).addExpr("SUM(c_integer)", 6).addExpr("SUM(c_bigint)", 6L).addExpr("SUM(c_float)", Float.valueOf(6.0f)).addExpr("SUM(c_double)", 6.0).addExpr("SUM(c_decimal)", BigDecimal.valueOf(6.0));
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="AVG", kind="AVG")
    public void testAvg() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("AVG(c_tinyint)", (byte)2).addExpr("AVG(c_smallint)", (short)2).addExpr("AVG(c_integer)", 2).addExpr("AVG(c_bigint)", 2L).addExpr("AVG(c_float)", Float.valueOf(2.0f)).addExpr("AVG(c_double)", 2.0).addExpr("AVG(c_decimal)", BigDecimal.valueOf(2.0));
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="$SUM0", kind="SUM0")
    public void testSUM0() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("$SUM0(c_tinyint)", (byte)6).addExpr("$SUM0(c_smallint)", (short)6).addExpr("$SUM0(c_integer)", 6).addExpr("$SUM0(c_bigint)", 6L).addExpr("$SUM0(c_float)", Float.valueOf(6.0f)).addExpr("$SUM0(c_double)", 6.0).addExpr("$SUM0(c_decimal)", BigDecimal.valueOf(6.0));
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="COUNT", kind="COUNT")
    public void testCount() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COUNT(*)", 4L).addExpr("COUNT(1)", 4L);
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="VAR_POP", kind="VAR_POP")
    public void testVARPOP() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("VAR_POP(c_integer)", 0).addExpr("VAR_POP(c_double)", 0.6666666);
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="VAR_SAMP", kind="VAR_SAMP")
    public void testVARSAMP() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("VAR_SAMP(c_integer)", 1).addExpr("VAR_SAMP(c_double)", 1.0);
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="COVAR_POP", kind="COVAR_POP")
    public void testCOVARPOP() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COVAR_POP(c_integer, c_integer_two)", 0).addExpr("COVAR_POP(c_double, c_double_two)", 0.6666666);
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="COVAR_SAMP", kind="COVAR_SAMP")
    public void testAggrationFunctions() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COVAR_SAMP(c_integer, c_integer_two)", 1).addExpr("COVAR_SAMP(c_double, c_double_two)", 1.0);
        checker.buildRunAndCheck(this.getAggregationTestPCollection());
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="CHARACTER_LENGTH", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="CHAR_LENGTH", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="INITCAP", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="LOWER", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="POSITION", kind="POSITION"), @SqlOperatorTest(name="OVERLAY", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="SUBSTRING", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="TRIM", kind="TRIM"), @SqlOperatorTest(name="UPPER", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="||", kind="OTHER")})
    public void testStringFunctions() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.SqlExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.SqlExpressionChecker().addExpr("'hello' || ' world' = 'hello world'").addExpr("'hello' || '' = 'hello'").addExpr("'' || '' = ''").addExpr("CHAR_LENGTH('hello') = 5").addExpr("CHARACTER_LENGTH('hello') = 5").addExpr("INITCAP('hello world') = 'Hello World'").addExpr("LOWER('HELLO') = 'hello'").addExpr("POSITION('world' IN 'helloworld') = 6").addExpr("POSITION('world' IN 'helloworldworld' FROM 7) = 11").addExpr("POSITION('world' IN 'hello') = 0").addExpr("TRIM(' hello ') = 'hello'").addExpr("TRIM(LEADING 'eh' FROM 'hehe__hehe') = '__hehe'").addExpr("TRIM(TRAILING 'eh' FROM 'hehe__hehe') = 'hehe__'").addExpr("TRIM(BOTH 'eh' FROM 'hehe__hehe') = '__'").addExpr("TRIM(BOTH ' ' FROM ' hello ') = 'hello'").addExpr("OVERLAY('w3333333rce' PLACING 'resou' FROM 3) = 'w3resou3rce'").addExpr("OVERLAY('w3333333rce' PLACING 'resou' FROM 3 FOR 4) = 'w3resou33rce'").addExpr("OVERLAY('w3333333rce' PLACING 'resou' FROM 3 FOR 5) = 'w3resou3rce'").addExpr("OVERLAY('w3333333rce' PLACING 'resou' FROM 3 FOR 7) = 'w3resouce'").addExpr("SUBSTRING('hello' FROM 2) = 'ello'").addExpr("SUBSTRING('hello' FROM -1) = 'o'").addExpr("SUBSTRING('hello' FROM 2 FOR 2) = 'el'").addExpr("SUBSTRING('hello' FROM 2 FOR 100) = 'ello'").addExpr("SUBSTRING('hello' FROM -3 for 2) = 'll'").addExpr("UPPER('hello') = 'HELLO'");
        checker.check((Pipeline)this.pipeline);
        this.pipeline.run();
    }

    @Test
    @SqlOperatorTest(name="ABS", kind="OTHER_FUNCTION")
    public void testAbs() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ABS(c_integer)", Math.abs(1)).addExpr("ABS(c_bigint)", Math.abs(1L)).addExpr("ABS(c_smallint)", (short)Math.abs(1)).addExpr("ABS(c_tinyint)", (byte)Math.abs(1)).addExpr("ABS(c_double)", Math.abs(1.0)).addExpr("ABS(c_float)", Float.valueOf(Math.abs(1.0f))).addExpr("ABS(c_decimal)", new BigDecimal(Math.abs(ONE.doubleValue())));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="LN", kind="OTHER_FUNCTION")
    public void testLn() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("LN(c_integer)", Math.log(1.0)).addExpr("LN(c_bigint)", Math.log(1.0)).addExpr("LN(c_smallint)", Math.log(1.0)).addExpr("LN(c_tinyint)", Math.log(1.0)).addExpr("LN(c_double)", Math.log(1.0)).addExpr("LN(c_float)", Math.log(1.0)).addExpr("LN(c_decimal)", Math.log(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="SQRT", kind="OTHER_FUNCTION")
    public void testSqrt() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("SQRT(c_integer)", Math.sqrt(1.0)).addExpr("SQRT(c_bigint)", Math.sqrt(1.0)).addExpr("SQRT(c_smallint)", Math.sqrt(1.0)).addExpr("SQRT(c_tinyint)", Math.sqrt(1.0)).addExpr("SQRT(c_double)", Math.sqrt(1.0)).addExpr("SQRT(c_float)", Math.sqrt(1.0)).addExpr("SQRT(c_decimal)", Math.sqrt(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="ROUND", kind="OTHER_FUNCTION")
    public void testRound() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ROUND(c_integer, 0)", SqlFunctions.sround(1, 0)).addExpr("ROUND(c_bigint, 0)", SqlFunctions.sround(1L, 0)).addExpr("ROUND(c_smallint, 0)", (short)SqlFunctions.sround(1, 0)).addExpr("ROUND(c_tinyint, 0)", (byte)SqlFunctions.sround(1, 0)).addExpr("ROUND(c_double, 0)", SqlFunctions.sround(1.0, 0)).addExpr("ROUND(c_float, 0)", Float.valueOf((float)SqlFunctions.sround(1.0, 0))).addExpr("ROUND(c_decimal, 0)", new BigDecimal(SqlFunctions.sround(ONE.doubleValue(), 0)));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="LOG10", kind="OTHER_FUNCTION")
    public void testLog10() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("LOG10(c_integer)", Math.log10(1.0)).addExpr("LOG10(c_bigint)", Math.log10(1.0)).addExpr("LOG10(c_smallint)", Math.log10(1.0)).addExpr("LOG10(c_tinyint)", Math.log10(1.0)).addExpr("LOG10(c_double)", Math.log10(1.0)).addExpr("LOG10(c_float)", Math.log10(1.0)).addExpr("LOG10(c_decimal)", Math.log10(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="EXP", kind="OTHER_FUNCTION")
    public void testExp() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("EXP(c_integer)", Math.exp(1.0)).addExpr("EXP(c_bigint)", Math.exp(1.0)).addExpr("EXP(c_smallint)", Math.exp(1.0)).addExpr("EXP(c_tinyint)", Math.exp(1.0)).addExpr("EXP(c_double)", Math.exp(1.0)).addExpr("EXP(c_float)", Math.exp(1.0)).addExpr("EXP(c_decimal)", Math.exp(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="ACOS", kind="OTHER_FUNCTION")
    public void testAcos() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ACOS(c_integer)", Math.acos(1.0)).addExpr("ACOS(c_bigint)", Math.acos(1.0)).addExpr("ACOS(c_smallint)", Math.acos(1.0)).addExpr("ACOS(c_tinyint)", Math.acos(1.0)).addExpr("ACOS(c_double)", Math.acos(1.0)).addExpr("ACOS(c_float)", Math.acos(1.0)).addExpr("ACOS(c_decimal)", Math.acos(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="ASIN", kind="OTHER_FUNCTION")
    public void testAsin() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ASIN(c_integer)", Math.asin(1.0)).addExpr("ASIN(c_bigint)", Math.asin(1.0)).addExpr("ASIN(c_smallint)", Math.asin(1.0)).addExpr("ASIN(c_tinyint)", Math.asin(1.0)).addExpr("ASIN(c_double)", Math.asin(1.0)).addExpr("ASIN(c_float)", Math.asin(1.0)).addExpr("ASIN(c_decimal)", Math.asin(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="ATAN", kind="OTHER_FUNCTION")
    public void testAtan() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ATAN(c_integer)", Math.atan(1.0)).addExpr("ATAN(c_bigint)", Math.atan(1.0)).addExpr("ATAN(c_smallint)", Math.atan(1.0)).addExpr("ATAN(c_tinyint)", Math.atan(1.0)).addExpr("ATAN(c_double)", Math.atan(1.0)).addExpr("ATAN(c_float)", Math.atan(1.0)).addExpr("ATAN(c_decimal)", Math.atan(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="COT", kind="OTHER_FUNCTION")
    public void testCot() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COT(c_integer)", 1.0 / Math.tan(1.0)).addExpr("COT(c_bigint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_smallint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_tinyint)", 1.0 / Math.tan(1.0)).addExpr("COT(c_double)", 1.0 / Math.tan(1.0)).addExpr("COT(c_float)", 1.0 / Math.tan(1.0)).addExpr("COT(c_decimal)", 1.0 / Math.tan(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="DEGREES", kind="OTHER_FUNCTION")
    public void testDegrees() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("DEGREES(c_integer)", Math.toDegrees(1.0)).addExpr("DEGREES(c_bigint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_smallint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_tinyint)", Math.toDegrees(1.0)).addExpr("DEGREES(c_double)", Math.toDegrees(1.0)).addExpr("DEGREES(c_float)", Math.toDegrees(1.0)).addExpr("DEGREES(c_decimal)", Math.toDegrees(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="RADIANS", kind="OTHER_FUNCTION")
    public void testRadians() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("RADIANS(c_integer)", Math.toRadians(1.0)).addExpr("RADIANS(c_bigint)", Math.toRadians(1.0)).addExpr("RADIANS(c_smallint)", Math.toRadians(1.0)).addExpr("RADIANS(c_tinyint)", Math.toRadians(1.0)).addExpr("RADIANS(c_double)", Math.toRadians(1.0)).addExpr("RADIANS(c_float)", Math.toRadians(1.0)).addExpr("RADIANS(c_decimal)", Math.toRadians(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="COS", kind="OTHER_FUNCTION")
    public void testCos() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COS(c_integer)", Math.cos(1.0)).addExpr("COS(c_bigint)", Math.cos(1.0)).addExpr("COS(c_smallint)", Math.cos(1.0)).addExpr("COS(c_tinyint)", Math.cos(1.0)).addExpr("COS(c_double)", Math.cos(1.0)).addExpr("COS(c_float)", Math.cos(1.0)).addExpr("COS(c_decimal)", Math.cos(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="SIN", kind="OTHER_FUNCTION")
    public void testSin() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("SIN(c_integer)", Math.sin(1.0)).addExpr("SIN(c_bigint)", Math.sin(1.0)).addExpr("SIN(c_smallint)", Math.sin(1.0)).addExpr("SIN(c_tinyint)", Math.sin(1.0)).addExpr("SIN(c_double)", Math.sin(1.0)).addExpr("SIN(c_float)", Math.sin(1.0)).addExpr("SIN(c_decimal)", Math.sin(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="TAN", kind="OTHER_FUNCTION")
    public void testTan() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TAN(c_integer)", Math.tan(1.0)).addExpr("TAN(c_bigint)", Math.tan(1.0)).addExpr("TAN(c_smallint)", Math.tan(1.0)).addExpr("TAN(c_tinyint)", Math.tan(1.0)).addExpr("TAN(c_double)", Math.tan(1.0)).addExpr("TAN(c_float)", Math.tan(1.0)).addExpr("TAN(c_decimal)", Math.tan(ONE.doubleValue()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="SIGN", kind="OTHER_FUNCTION")
    public void testSign() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("SIGN(c_integer)", Integer.signum(1)).addExpr("SIGN(c_bigint)", Long.signum(1L)).addExpr("SIGN(c_smallint)", (short)Integer.signum(1)).addExpr("SIGN(c_tinyint)", (byte)Integer.signum(1)).addExpr("SIGN(c_double)", Math.signum(1.0)).addExpr("SIGN(c_float)", Float.valueOf(Math.signum(1.0f))).addExpr("SIGN(c_decimal)", BigDecimal.valueOf(ONE.signum()));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="POWER", kind="OTHER_FUNCTION")
    public void testPower() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("POWER(c_integer, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_bigint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_smallint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_tinyint, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_double, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_float, 2)", Math.pow(1.0, 2.0)).addExpr("POWER(c_decimal, 2)", Math.pow(ONE.doubleValue(), 2.0));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="PI", kind="OTHER_FUNCTION")
    public void testPi() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("PI", Math.PI);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="ATAN2", kind="OTHER_FUNCTION")
    public void testAtan2() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ATAN2(c_integer, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_bigint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_smallint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_tinyint, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_double, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_float, 2)", Math.atan2(1.0, 2.0)).addExpr("ATAN2(c_decimal, 2)", Math.atan2(ONE.doubleValue(), 2.0));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="TRUNCATE", kind="OTHER_FUNCTION")
    public void testTruncate() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TRUNCATE(c_integer, 2)", SqlFunctions.struncate(1, 2)).addExpr("TRUNCATE(c_bigint, 2)", SqlFunctions.struncate(1L, 2)).addExpr("TRUNCATE(c_smallint, 2)", (short)SqlFunctions.struncate(1, 2)).addExpr("TRUNCATE(c_tinyint, 2)", (byte)SqlFunctions.struncate(1, 2)).addExpr("TRUNCATE(c_double, 2)", SqlFunctions.struncate(1.0, 2)).addExpr("TRUNCATE(c_float, 2)", Float.valueOf((float)SqlFunctions.struncate(1.0, 2))).addExpr("TRUNCATE(c_decimal, 2)", SqlFunctions.struncate(ONE, 2));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="RAND", kind="OTHER_FUNCTION")
    public void testRand() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("RAND(c_integer)", new Random(65537L).nextDouble());
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="RAND_INTEGER", kind="OTHER_FUNCTION")
    public void testRandInteger() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("RAND_INTEGER(c_integer, c_integer)", new Random(1L).nextInt(1));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="ARRAY", kind="ARRAY_VALUE_CONSTRUCTOR"), @SqlOperatorTest(name="CARDINALITY", kind="OTHER_FUNCTION"), @SqlOperatorTest(name="ELEMENT", kind="OTHER_FUNCTION")})
    public void testArrayFunctions() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ARRAY ['a', 'b']", ImmutableList.of((Object)"a", (Object)"b"), Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).addExpr("CARDINALITY(ARRAY ['a', 'b', 'c'])", 3).addExpr("ELEMENT(ARRAY [1])", 1);
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="DAYOFMONTH", kind="OTHER"), @SqlOperatorTest(name="DAYOFWEEK", kind="OTHER"), @SqlOperatorTest(name="DAYOFYEAR", kind="OTHER"), @SqlOperatorTest(name="EXTRACT", kind="EXTRACT"), @SqlOperatorTest(name="YEAR", kind="OTHER"), @SqlOperatorTest(name="QUARTER", kind="OTHER"), @SqlOperatorTest(name="MONTH", kind="OTHER"), @SqlOperatorTest(name="WEEK", kind="OTHER"), @SqlOperatorTest(name="HOUR", kind="OTHER"), @SqlOperatorTest(name="MINUTE", kind="OTHER"), @SqlOperatorTest(name="SECOND", kind="OTHER")})
    public void testBasicDateTimeFunctions() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("EXTRACT(YEAR FROM ts)", 1986L).addExpr("YEAR(ts)", 1986L).addExpr("QUARTER(ts)", 1L).addExpr("MONTH(ts)", 2L).addExpr("WEEK(ts)", 7L).addExpr("DAYOFMONTH(ts)", 15L).addExpr("DAYOFYEAR(ts)", 46L).addExpr("DAYOFWEEK(ts)", 7L).addExpr("HOUR(ts)", 11L).addExpr("MINUTE(ts)", 35L).addExpr("SECOND(ts)", 26L);
        checker.buildRunAndCheck();
    }

    @Test
    public void testFloor() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("FLOOR(ts TO SECOND)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:35:26")).addExpr("FLOOR(ts TO MINUTE)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:35:00")).addExpr("FLOOR(ts TO HOUR)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:00:00")).addExpr("FLOOR(ts TO DAY)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 00:00:00")).addExpr("FLOOR(ts TO MONTH)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-01 00:00:00")).addExpr("FLOOR(ts TO YEAR)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-01-01 00:00:00")).addExpr("FLOOR(c_double)", 1.0);
        checker.buildRunAndCheck(this.getFloorCeilingTestPCollection());
    }

    @Test
    public void testCeil() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("CEIL(ts TO SECOND)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:35:26")).addExpr("CEIL(ts TO MINUTE)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 11:36:00")).addExpr("CEIL(ts TO HOUR)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-15 12:00:00")).addExpr("CEIL(ts TO DAY)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-02-16 00:00:00")).addExpr("CEIL(ts TO MONTH)", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-03-01 00:00:00")).addExpr("CEIL(ts TO YEAR)", DateTimeUtils.parseTimestampWithUTCTimeZone("1987-01-01 00:00:00")).addExpr("CEIL(c_double)", 2.0);
        checker.buildRunAndCheck(this.getFloorCeilingTestPCollection());
    }

    @Test
    @SqlOperatorTest(name="TIMESTAMPADD", kind="TIMESTAMP_ADD")
    public void testDatetimePlusFunction() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TIMESTAMPADD(SECOND, 3, TIMESTAMP '1984-04-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-19 01:02:06")).addExpr("TIMESTAMPADD(MINUTE, 3, TIMESTAMP '1984-04-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-19 01:05:03")).addExpr("TIMESTAMPADD(HOUR, 3, TIMESTAMP '1984-04-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-19 04:02:03")).addExpr("TIMESTAMPADD(DAY, 3, TIMESTAMP '1984-04-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-22 01:02:03")).addExpr("TIMESTAMPADD(MONTH, 2, TIMESTAMP '1984-01-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-03-19 01:02:03")).addExpr("TIMESTAMPADD(YEAR, 2, TIMESTAMP '1985-01-19 01:02:03')", DateTimeUtils.parseTimestampWithUTCTimeZone("1987-01-19 01:02:03"));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="+", kind="PLUS")
    public void testDatetimeInfixPlus() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '3' SECOND", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-01-19 01:02:06")).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '2' MINUTE", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-01-19 01:04:03")).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '2' HOUR", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-01-19 03:02:03")).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '2' DAY", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-01-21 01:02:03")).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '2' MONTH", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-03-19 01:02:03")).addExpr("TIMESTAMP '1984-01-19 01:02:03' + INTERVAL '2' YEAR", DateTimeUtils.parseTimestampWithUTCTimeZone("1986-01-19 01:02:03")).addExpr("DATE '1984-04-19' + INTERVAL '2' DAY", DateTimeUtils.parseDate("1984-04-21")).addExpr("DATE '1984-04-19' + INTERVAL '1' MONTH", DateTimeUtils.parseDate("1984-05-19")).addExpr("DATE '1984-04-19' + INTERVAL '3' YEAR", DateTimeUtils.parseDate("1987-04-19")).addExpr("TIME '14:28:30' + INTERVAL '15' SECOND", DateTimeUtils.parseTime("14:28:45")).addExpr("TIME '14:28:30.239' + INTERVAL '4' MINUTE", DateTimeUtils.parseTime("14:32:30.239")).addExpr("TIME '14:28:30.2' + INTERVAL '4' HOUR", DateTimeUtils.parseTime("18:28:30.2"));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTest(name="TIMESTAMPDIFF", kind="TIMESTAMP_DIFF")
    public void testTimestampDiff() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TIMESTAMPDIFF(SECOND, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:01:58')", 0).addExpr("TIMESTAMPDIFF(SECOND, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:01:59')", 1).addExpr("TIMESTAMPDIFF(SECOND, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:02:00')", 2).addExpr("TIMESTAMPDIFF(MINUTE, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:02:57')", 0).addExpr("TIMESTAMPDIFF(MINUTE, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:02:58')", 1).addExpr("TIMESTAMPDIFF(MINUTE, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 01:03:58')", 2).addExpr("TIMESTAMPDIFF(HOUR, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 02:01:57')", 0).addExpr("TIMESTAMPDIFF(HOUR, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 02:01:58')", 1).addExpr("TIMESTAMPDIFF(HOUR, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-19 03:01:58')", 2).addExpr("TIMESTAMPDIFF(DAY, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-20 01:01:57')", 0).addExpr("TIMESTAMPDIFF(DAY, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-20 01:01:58')", 1).addExpr("TIMESTAMPDIFF(DAY, TIMESTAMP '1984-04-19 01:01:58', TIMESTAMP '1984-04-21 01:01:58')", 2).addExpr("TIMESTAMPDIFF(MONTH, TIMESTAMP '1984-01-19 01:01:58', TIMESTAMP '1984-02-19 01:01:57')", 0).addExpr("TIMESTAMPDIFF(MONTH, TIMESTAMP '1984-01-19 01:01:58', TIMESTAMP '1984-02-19 01:01:58')", 1).addExpr("TIMESTAMPDIFF(MONTH, TIMESTAMP '1984-01-19 01:01:58', TIMESTAMP '1984-03-19 01:01:58')", 2).addExpr("TIMESTAMPDIFF(YEAR, TIMESTAMP '1981-01-19 01:01:58', TIMESTAMP '1982-01-19 01:01:57')", 0).addExpr("TIMESTAMPDIFF(YEAR, TIMESTAMP '1981-01-19 01:01:58', TIMESTAMP '1982-01-19 01:01:58')", 1).addExpr("TIMESTAMPDIFF(YEAR, TIMESTAMP '1981-01-19 01:01:58', TIMESTAMP '1983-01-19 01:01:58')", 2).addExpr("TIMESTAMPDIFF(YEAR, TIMESTAMP '1981-01-19 01:01:58', TIMESTAMP '1980-01-19 01:01:58')", -1).addExpr("TIMESTAMPDIFF(YEAR, TIMESTAMP '1981-01-19 01:01:58', TIMESTAMP '1979-01-19 01:01:58')", -2);
        checker.buildRunAndCheck();
    }

    @Test
    public void testTimestampMinusInterval() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TIMESTAMP '1984-04-19 01:01:58' - INTERVAL '2' SECOND", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-19 01:01:56")).addExpr("TIMESTAMP '1984-04-19 01:01:58' - INTERVAL '1' MINUTE", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-19 01:00:58")).addExpr("TIMESTAMP '1984-04-19 01:01:58' - INTERVAL '4' HOUR", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-18 21:01:58")).addExpr("TIMESTAMP '1984-04-19 01:01:58' - INTERVAL '5' DAY", DateTimeUtils.parseTimestampWithUTCTimeZone("1984-04-14 01:01:58")).addExpr("TIMESTAMP '1984-01-19 01:01:58' - INTERVAL '2' MONTH", DateTimeUtils.parseTimestampWithUTCTimeZone("1983-11-19 01:01:58")).addExpr("TIMESTAMP '1984-01-19 01:01:58' - INTERVAL '1' YEAR", DateTimeUtils.parseTimestampWithUTCTimeZone("1983-01-19 01:01:58")).addExpr("DATE '1984-04-19' - INTERVAL '2' DAY", DateTimeUtils.parseDate("1984-04-17")).addExpr("DATE '1984-04-19' - INTERVAL '1' MONTH", DateTimeUtils.parseDate("1984-03-19")).addExpr("DATE '1984-04-19' - INTERVAL '3' YEAR", DateTimeUtils.parseDate("1981-04-19")).addExpr("TIME '14:28:30' - INTERVAL '15' SECOND", DateTimeUtils.parseTime("14:28:15")).addExpr("TIME '14:28:30.239' - INTERVAL '4' MINUTE", DateTimeUtils.parseTime("14:24:30.239")).addExpr("TIME '14:28:30.2' - INTERVAL '4' HOUR", DateTimeUtils.parseTime("10:28:30.2"));
        checker.buildRunAndCheck();
    }

    @Test
    @SqlOperatorTests(value={@SqlOperatorTest(name="CASE", kind="CASE"), @SqlOperatorTest(name="NULLIF", kind="NULLIF"), @SqlOperatorTest(name="COALESCE", kind="COALESCE")})
    public void testConditionalOperatorsAndFunctions() {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("CASE 1 WHEN 1 THEN 'hello' ELSE 'world' END", "hello").addExpr("CASE 2 WHEN 1 THEN 'hello' WHEN 3 THEN 'bond' ELSE 'world' END", "world").addExpr("CASE 3 WHEN 1 THEN 'hello' WHEN 3 THEN 'bond' ELSE 'world' END", "bond").addExpr("CASE WHEN 1 = 1 THEN 'hello' ELSE 'world' END", "hello").addExpr("CASE WHEN 1 > 1 THEN 'hello' ELSE 'world' END", "world").addExpr("NULLIF(5, 4) ", 5).addExpr("NULLIF(4, 5) ", 4).addExpr("NULLIF(5, 5)", null, Schema.FieldType.INT32).addExpr("COALESCE(1, 5) ", 1).addExpr("COALESCE(NULL, 5) ", 5).addExpr("COALESCE(NULL, 4, 5) ", 4).addExpr("COALESCE(NULL, NULL, 5) ", 5).addExpr("COALESCE(5, NULL) ", 5);
        checker.buildRunAndCheck();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Repeatable(value=SqlOperatorTests.class)
    private static @interface SqlOperatorTest {
        public String name();

        public String kind();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface SqlOperatorTests {
        public SqlOperatorTest[] value();
    }

    @AutoValue
    static abstract class SqlOperatorId {
        SqlOperatorId() {
        }

        abstract String name();

        abstract SqlKind kind();
    }
}

