/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.utils.RowAsserts;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BeamSqlDslAggregationVarianceTest {
    private static final double PRECISION = 1.0E-7;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private PCollection<Row> boundedInput;

    @Before
    public void setUp() {
        Schema schema = Schema.builder().addInt32Field("f_int").addDoubleField("f_double").addInt32Field("f_int2").build();
        List<Row> rowsInTableB = TestUtils.RowsBuilder.of(schema).addRows(1, 1.0, 0, 4, 4.0, 0, 7, 7.0, 0, 13, 13.0, 0, 5, 5.0, 0, 10, 10.0, 0, 17, 17.0, 0).getRows();
        this.boundedInput = (PCollection)this.pipeline.apply((PTransform)Create.of(rowsInTableB).withSchema(schema, SerializableFunctions.identity(), SerializableFunctions.identity()));
    }

    @Test
    public void testPopulationVarianceDouble() {
        String sql = "SELECT VAR_POP(f_double) FROM PCOLLECTION GROUP BY f_int2";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(26.40816326, 1.0E-7));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testPopulationVarianceInt() {
        String sql = "SELECT VAR_POP(f_int) FROM PCOLLECTION GROUP BY f_int2";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(26));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testSampleVarianceDouble() {
        String sql = "SELECT VAR_SAMP(f_double) FROM PCOLLECTION GROUP BY f_int2";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(30.80952381, 1.0E-7));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testSampleVarianceInt() {
        String sql = "SELECT VAR_SAMP(f_int) FROM PCOLLECTION GROUP BY f_int2";
        PAssert.that((PCollection)((PCollection)this.boundedInput.apply((PTransform)SqlTransform.query((String)sql)))).satisfies(RowAsserts.matchesScalar(30));
        this.pipeline.run().waitUntilFinish();
    }
}

