/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping;

import java.util.Iterator;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.IntPair;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.Mapping;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.MappingType;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.mapping.Mappings;

public abstract class AbstractTargetMapping
extends Mappings.AbstractMapping
implements Mapping {
    private final int sourceCount;
    private final int targetCount;

    public AbstractTargetMapping(int sourceCount, int targetCount) {
        this.sourceCount = sourceCount;
        this.targetCount = targetCount;
    }

    @Override
    public int getSourceCount() {
        return this.sourceCount;
    }

    @Override
    public int getTargetCount() {
        return this.targetCount;
    }

    @Override
    public Mapping inverse() {
        return Mappings.invert(this);
    }

    @Override
    public int size() {
        return this.sourceCount;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.PARTIAL_FUNCTION;
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new Iterator<IntPair>(){
            int source = -1;
            int target;
            {
                this.moveToNext();
            }

            private void moveToNext() {
                while (++this.source < AbstractTargetMapping.this.sourceCount) {
                    this.target = AbstractTargetMapping.this.getTargetOpt(this.source);
                    if (this.target < 0) continue;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.source < AbstractTargetMapping.this.sourceCount;
            }

            @Override
            public IntPair next() {
                IntPair p = new IntPair(this.source, this.target);
                this.moveToNext();
                return p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public abstract int getTargetOpt(int var1);
}

