/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelDistribution;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelDistributions;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelInput;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.SingleRel;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Util;

public abstract class Exchange
extends SingleRel {
    public final RelDistribution distribution;

    protected Exchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution) {
        super(cluster, traitSet, input);
        this.distribution = Objects.requireNonNull(distribution);
        assert (traitSet.containsIfApplicable(distribution)) : "traits=" + traitSet + ", distribution" + distribution;
        assert (distribution != RelDistributions.ANY);
    }

    public Exchange(RelInput input) {
        this(input.getCluster(), input.getTraitSet().plus(input.getCollation()), input.getInput(), RelDistributionTraitDef.INSTANCE.canonize(input.getDistribution()));
    }

    @Override
    public final Exchange copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Exchange.sole(inputs), this.distribution);
    }

    public abstract Exchange copy(RelTraitSet var1, RelNode var2, RelDistribution var3);

    public RelDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double bytesPerRow = this.getRowType().getFieldCount() * 4;
        return planner.getCostFactory().makeCost(Util.nLogN(rowCount) * bytesPerRow, rowCount, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("distribution", this.distribution);
    }
}

