/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.utils;

import java.io.Serializable;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.junit.Assert;

public class RowAsserts {
    public static SerializableFunction<Iterable<Row>, Void> matchesScalar(int expected) {
        return (SerializableFunction & Serializable)records -> {
            Row row = (Row)Iterables.getOnlyElement((Iterable)records);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((long)expected, (long)row.getInt32(0).intValue());
            return null;
        };
    }

    public static SerializableFunction<Iterable<Row>, Void> matchesScalar(long expected) {
        return (SerializableFunction & Serializable)records -> {
            Row row = (Row)Iterables.getOnlyElement((Iterable)records);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((long)expected, (long)row.getInt64(0));
            return null;
        };
    }

    public static SerializableFunction<Iterable<Row>, Void> matchesScalar(double expected, double delta) {
        return (SerializableFunction & Serializable)input -> {
            Row row = (Row)Iterables.getOnlyElement((Iterable)input);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((double)expected, (double)row.getDouble(0), (double)delta);
            return null;
        };
    }

    public static SerializableFunction<Iterable<Row>, Void> matchesScalar(float expected, float delta) {
        return (SerializableFunction & Serializable)input -> {
            Row row = (Row)Iterables.getOnlyElement((Iterable)input);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((float)expected, (float)row.getFloat(0).floatValue(), (float)delta);
            return null;
        };
    }
}

