/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udf;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.extensions.sql.integrationtest.BeamSqlBuiltinFunctionsIntegrationTestBase;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BeamSqlUdfExpressionTest
extends BeamSqlBuiltinFunctionsIntegrationTestBase {
    @Test
    public void testCOSH() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("COSH(CAST(1.0 as DOUBLE))", Math.cosh(1.0)).addExpr("COSH(CAST(710.0 as DOUBLE))", Math.cosh(710.0)).addExpr("COSH(CAST(-1.0 as DOUBLE))", Math.cosh(-1.0)).addExprWithNullExpectedValue("COSH(CAST(NULL as DOUBLE))", Schema.TypeName.DOUBLE);
        checker.buildRunAndCheck();
    }

    @Test
    public void testSINH() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("SINH(CAST(1.0 as DOUBLE))", Math.sinh(1.0)).addExpr("SINH(CAST(710.0 as DOUBLE))", Math.sinh(710.0)).addExpr("SINH(CAST(-1.0 as DOUBLE))", Math.sinh(-1.0)).addExprWithNullExpectedValue("SINH(CAST(NULL as DOUBLE))", Schema.TypeName.DOUBLE);
        checker.buildRunAndCheck();
    }

    @Test
    public void testTANH() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("TANH(CAST(1.0 as DOUBLE))", Math.tanh(1.0)).addExpr("TANH(CAST(0.0 as DOUBLE))", Math.tanh(0.0)).addExpr("TANH(CAST(-1.0 as DOUBLE))", Math.tanh(-1.0)).addExprWithNullExpectedValue("TANH(CAST(NULL as DOUBLE))", Schema.TypeName.DOUBLE);
        checker.buildRunAndCheck();
    }

    @Test
    public void testEndsWith() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("ENDS_WITH('string1', 'g1')", true).addExpr("ENDS_WITH('string2', 'g1')", false).addExpr("ENDS_WITH('', '')", true).addExpr("ENDS_WITH('\u4e2d\u6587', '\u6587')", true).addExpr("ENDS_WITH('\u4e2d\u6587', '\u4e2d')", false);
        checker.buildRunAndCheck();
    }

    @Test
    public void testStartsWith() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("STARTS_WITH('string1', 'stri')", true).addExpr("STARTS_WITH('string2', 'str1')", false).addExpr("STARTS_WITH('', '')", true).addExpr("STARTS_WITH('\u4e2d\u6587', '\u6587')", false).addExpr("STARTS_WITH('\u4e2d\u6587', '\u4e2d')", true);
        checker.buildRunAndCheck();
    }

    @Test
    public void testLength() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("LENGTH('')", 0L).addExpr("LENGTH('abcde')", 5L).addExpr("LENGTH('\u4e2d\u6587')", 2L).addExpr("LENGTH('\u0000\u0000')", 2L).addExpr("LENGTH('\u0430\u0431\u0432\u0433\u0434')", 5L).addExprWithNullExpectedValue("LENGTH(CAST(NULL as VARCHAR(0)))", Schema.TypeName.INT64).addExprWithNullExpectedValue("LENGTH(CAST(NULL as VARBINARY(0)))", Schema.TypeName.INT64);
        checker.buildRunAndCheck();
    }

    @Test
    public void testReverse() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("REVERSE('')", "").addExpr("REVERSE('foo')", "oof").addExpr("REVERSE('\u4e2d\u6587')", "\u6587\u4e2d").addExpr("REVERSE('\u0430\u0431\u0432\u0433\u0434')", "\u0434\u0433\u0432\u0431\u0430").addExprWithNullExpectedValue("REVERSE(CAST(NULL as VARCHAR(0)))", Schema.TypeName.STRING).addExprWithNullExpectedValue("REVERSE(CAST(NULL as VARBINARY(0)))", Schema.TypeName.STRING);
        checker.buildRunAndCheck();
    }

    @Test
    public void testFromHex() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("FROM_HEX('666f6f626172')", "foobar".getBytes(StandardCharsets.UTF_8)).addExpr("FROM_HEX('20')", " ".getBytes(StandardCharsets.UTF_8)).addExpr("FROM_HEX('616263414243')", "abcABC".getBytes(StandardCharsets.UTF_8)).addExpr("FROM_HEX('616263414243d0b6d189d184d096d0a9d0a4')", "abcABC\u0436\u0449\u0444\u0416\u0429\u0424".getBytes(StandardCharsets.UTF_8)).addExprWithNullExpectedValue("FROM_HEX(CAST(NULL as VARCHAR(0)))", Schema.TypeName.BYTES);
        checker.buildRunAndCheck();
    }

    @Test
    public void testToHex() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExprWithNullExpectedValue("TO_HEX(CAST(NULL as VARBINARY(0)))", Schema.TypeName.STRING);
        checker.buildRunAndCheck();
    }

    @Test
    public void testLeftPad() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("LPAD('abcdef', CAST(0 AS BIGINT))", "").addExpr("LPAD('abcdef', CAST(0 AS BIGINT), 'defgh')", "").addExpr("LPAD('abcdef', CAST(6 AS BIGINT), 'defgh')", "abcdef").addExpr("LPAD('abcdef', CAST(5 AS BIGINT), 'defgh')", "abcde").addExpr("LPAD('abcdef', CAST(4 AS BIGINT), 'defgh')", "abcd").addExpr("LPAD('abcdef', CAST(3 AS BIGINT), 'defgh')", "abc").addExpr("LPAD('abc', CAST(4 AS BIGINT), 'defg')", "dabc").addExpr("LPAD('abc', CAST(5 AS BIGINT), 'defgh')", "deabc").addExpr("LPAD('abc', CAST(6 AS BIGINT), 'defgh')", "defabc").addExpr("LPAD('abc', CAST(7 AS BIGINT), 'defg')", "defgabc").addExpr("LPAD('abcd', CAST(10 AS BIGINT), 'defg')", "defgdeabcd").addExpr("LPAD('\u4e2d\u6587', CAST(10 AS BIGINT), '\u0436\u0449\u0444\u0416\u0429\u0424')", "\u0436\u0449\u0444\u0416\u0429\u0424\u0436\u0449\u4e2d\u6587").addExpr("LPAD('', CAST(5 AS BIGINT), ' ')", "     ").addExpr("LPAD('', CAST(3 AS BIGINT), '-')", "---").addExpr("LPAD('a', CAST(5 AS BIGINT), ' ')", "    a").addExpr("LPAD('a', CAST(3 AS BIGINT), '-')", "--a").addExprWithNullExpectedValue("LPAD(CAST(NULL AS VARCHAR(0)), CAST(3 AS BIGINT), '-')", Schema.TypeName.STRING).addExprWithNullExpectedValue("LPAD('', CAST(NULL AS BIGINT), '-')", Schema.TypeName.STRING).addExprWithNullExpectedValue("LPAD('', CAST(3 AS BIGINT), CAST(NULL AS VARCHAR(0)))", Schema.TypeName.STRING);
        checker.buildRunAndCheck();
    }

    @Test
    public void testRightPad() throws Exception {
        BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker checker = new BeamSqlBuiltinFunctionsIntegrationTestBase.ExpressionChecker(this).addExpr("RPAD('abcdef', CAST(0 AS BIGINT))", "").addExpr("RPAD('abcdef', CAST(0 AS BIGINT), 'defgh')", "").addExpr("RPAD('abcdef', CAST(6 AS BIGINT), 'defgh')", "abcdef").addExpr("RPAD('abcdef', CAST(5 AS BIGINT), 'defgh')", "abcde").addExpr("RPAD('abcdef', CAST(4 AS BIGINT), 'defgh')", "abcd").addExpr("RPAD('abcdef', CAST(3 AS BIGINT), 'defgh')", "abc").addExpr("RPAD('abc', CAST(4 AS BIGINT), 'defg')", "abcd").addExpr("RPAD('abc', CAST(5 AS BIGINT), 'defgh')", "abcde").addExpr("RPAD('abc', CAST(6 AS BIGINT), 'defgh')", "abcdef").addExpr("RPAD('abc', CAST(7 AS BIGINT), 'defg')", "abcdefg").addExpr("RPAD('abcd', CAST(10 AS BIGINT), 'defg')", "abcddefgde").addExpr("RPAD('\u4e2d\u6587', CAST(10 AS BIGINT), '\u0436\u0449\u0444\u0416\u0429\u0424')", "\u4e2d\u6587\u0436\u0449\u0444\u0416\u0429\u0424\u0436\u0449").addExpr("RPAD('', CAST(5 AS BIGINT), ' ')", "     ").addExpr("RPAD('', CAST(3 AS BIGINT), '-')", "---").addExpr("RPAD('a', CAST(5 AS BIGINT), ' ')", "a    ").addExpr("RPAD('a', CAST(3 AS BIGINT), '-')", "a--").addExprWithNullExpectedValue("RPAD(CAST(NULL AS VARCHAR(0)), CAST(3 AS BIGINT), '-')", Schema.TypeName.STRING).addExprWithNullExpectedValue("RPAD('', CAST(NULL AS BIGINT), '-')", Schema.TypeName.STRING).addExprWithNullExpectedValue("RPAD('', CAST(3 AS BIGINT), CAST(NULL AS VARCHAR(0)))", Schema.TypeName.STRING);
        checker.buildRunAndCheck();
    }
}

