/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udf;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BeamSalUhfSpecialTypeAndValueTest
extends BeamSqlDslBase {
    @Test
    public void testIsInf() throws Exception {
        Schema resultType = Schema.builder().addBooleanField("field_1").addBooleanField("field_2").addBooleanField("field_3").addBooleanField("field_4").build();
        Row resultRow = Row.withSchema((Schema)resultType).addValues(new Object[]{true, true, true, true}).build();
        String sql = "SELECT IS_INF(f_float_1), IS_INF(f_double_1), IS_INF(f_float_2), IS_INF(f_double_2) FROM PCOLLECTION";
        PCollection result = (PCollection)this.boundedInputFloatDouble.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testIsNan() throws Exception {
        Schema resultType = Schema.builder().addBooleanField("field_1").addBooleanField("field_2").addBooleanField("field_3").addBooleanField("field_4").build();
        Row resultRow = Row.withSchema((Schema)resultType).addValues(new Object[]{false, false, true, true}).build();
        String sql = "SELECT IS_NAN(f_float_2), IS_NAN(f_double_2), IS_NAN(f_float_3), IS_NAN(f_double_3) FROM PCOLLECTION";
        PCollection result = (PCollection)this.boundedInputFloatDouble.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testLength() throws Exception {
        Schema resultType = Schema.builder().addInt64Field("field").build();
        Row resultRow = Row.withSchema((Schema)resultType).addValues(new Object[]{10L}).build();
        Row resultRow2 = Row.withSchema((Schema)resultType).addValues(new Object[]{0L}).build();
        Row resultRow3 = Row.withSchema((Schema)resultType).addValues(new Object[]{2L}).build();
        String sql = "SELECT LENGTH(f_bytes) FROM PCOLLECTION WHERE f_func = 'LENGTH'";
        PCollection result = (PCollection)this.boundedInputBytes.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow, resultRow2, resultRow3});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testReverse() throws Exception {
        byte[] testByets = "\u0430\u0431\u0432\u0433\u0434".getBytes(StandardCharsets.UTF_8);
        ArrayUtils.reverse((byte[])testByets);
        Schema resultType = Schema.builder().addByteArrayField("field").build();
        Row resultRow = Row.withSchema((Schema)resultType).addValues(new Object[]{testByets}).build();
        Row resultRow2 = Row.withSchema((Schema)resultType).addValues(new Object[]{"\u0001\u0000".getBytes(StandardCharsets.UTF_8)}).build();
        Row resultRow3 = Row.withSchema((Schema)resultType).addValues(new Object[]{"".getBytes(StandardCharsets.UTF_8)}).build();
        String sql = "SELECT REVERSE(f_bytes) FROM PCOLLECTION WHERE f_func = 'LENGTH'";
        PCollection result = (PCollection)this.boundedInputBytes.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow, resultRow2, resultRow3});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testToHex() throws Exception {
        Schema resultType = Schema.builder().addStringField("field").build();
        Row resultRow = Row.withSchema((Schema)resultType).addValue((Object)"666f6f626172").build();
        Row resultRow2 = Row.withSchema((Schema)resultType).addValue((Object)"20").build();
        Row resultRow3 = Row.withSchema((Schema)resultType).addValue((Object)"616263414243").build();
        Row resultRow4 = Row.withSchema((Schema)resultType).addValue((Object)"616263414243d0b6d189d184d096d0a9d0a4").build();
        String sql = "SELECT TO_HEX(f_bytes) FROM PCOLLECTION WHERE f_func = 'TO_HEX'";
        PCollection result = (PCollection)this.boundedInputBytes.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow, resultRow2, resultRow3, resultRow4});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testLeftPad() throws Exception {
        Schema resultType = Schema.builder().addNullableField("field", Schema.FieldType.BYTES).build();
        Row resultRow = Row.withSchema((Schema)resultType).addValue((Object)"".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow2 = Row.withSchema((Schema)resultType).addValue((Object)"abcdef".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow3 = Row.withSchema((Schema)resultType).addValue((Object)"abcd".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow4 = Row.withSchema((Schema)resultType).addValue((Object)"defgabcdef".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow5 = Row.withSchema((Schema)resultType).addValue((Object)"defghdeabc".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow6 = Row.withSchema((Schema)resultType).addValue((Object)"----abc".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow7 = Row.withSchema((Schema)resultType).addValue((Object)"defdefd".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow8 = Row.withSchema((Schema)resultType).addValue(null).build();
        String sql = "SELECT LPAD(f_bytes_one, length, f_bytes_two) FROM PCOLLECTION";
        PCollection result = (PCollection)this.boundedInputBytesPaddingTest.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow, resultRow2, resultRow3, resultRow4, resultRow5, resultRow6, resultRow7, resultRow8});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testRightPad() throws Exception {
        Schema resultType = Schema.builder().addNullableField("field", Schema.FieldType.BYTES).build();
        Row resultRow = Row.withSchema((Schema)resultType).addValue((Object)"".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow2 = Row.withSchema((Schema)resultType).addValue((Object)"abcdef".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow3 = Row.withSchema((Schema)resultType).addValue((Object)"abcd".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow4 = Row.withSchema((Schema)resultType).addValue((Object)"abcdefdefg".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow5 = Row.withSchema((Schema)resultType).addValue((Object)"abcdefghde".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow6 = Row.withSchema((Schema)resultType).addValue((Object)"abc----".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow7 = Row.withSchema((Schema)resultType).addValue((Object)"defdefd".getBytes(StandardCharsets.UTF_8)).build();
        Row resultRow8 = Row.withSchema((Schema)resultType).addValue(null).build();
        String sql = "SELECT RPAD(f_bytes_one, length, f_bytes_two) FROM PCOLLECTION";
        PCollection result = (PCollection)this.boundedInputBytesPaddingTest.apply("testUdf", (PTransform)SqlTransform.query((String)sql));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{resultRow, resultRow2, resultRow3, resultRow4, resultRow5, resultRow6, resultRow7, resultRow8});
        this.pipeline.run().waitUntilFinish();
    }
}

