/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamValuesRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamValuesRelTest.registerTable("string_table", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.STRING, "name", Schema.FieldType.STRING, "description"}));
        BeamValuesRelTest.registerTable("int_table", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "c0", Schema.FieldType.INT32, "c1"}));
    }

    @Test
    public void testValues() throws Exception {
        String sql = "insert into string_table(name, description) values ('hello', 'world'), ('james', 'bond')";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.STRING, "name", Schema.FieldType.STRING, "description").addRows("hello", "world", "james", "bond").getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_castInt() throws Exception {
        String sql = "insert into int_table (c0, c1) values(cast(1 as int), cast(2 as int))";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "c0", Schema.FieldType.INT32, "c1").addRows(1, 2).getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_onlySelect() throws Exception {
        String sql = "select 1, '1'";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "EXPR$0", Schema.FieldType.STRING, "EXPR$1").addRows(1, "1").getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_selectEmpty() throws Exception {
        String sql = "select 1, '1' FROM string_table WHERE false";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "EXPR$0", Schema.FieldType.STRING, "EXPR$1").getRows());
        this.pipeline.run();
    }
}

