/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamSetOperatorRelBaseTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    public static final DateTime THE_DATE = new DateTime(100000L);

    @BeforeClass
    public static void prepare() {
        BeamSetOperatorRelBaseTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price", Schema.FieldType.DATETIME, "order_time"}).addRows(new Object[]{1L, 1, 1.0, THE_DATE, 2L, 2, 2.0, THE_DATE}));
    }

    @Test
    public void testSameWindow() throws Exception {
        String sql = "SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR)  UNION SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR) ";
        PCollection<Row> rows = BeamSetOperatorRelBaseTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that((PCollection)((PCollection)rows.apply((PTransform)ParDo.of((DoFn)new TestUtils.BeamSqlRow2StringDoFn())))).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT64, "cnt").addRows(1L, 1, 1L, 2L, 2, 1L).getStringRows());
        this.pipeline.run();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDifferentWindows() throws Exception {
        String sql = "SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '1' HOUR)  UNION SELECT  order_id, site_id, count(*) as cnt FROM ORDER_DETAILS GROUP BY order_id, site_id, TUMBLE(order_time, INTERVAL '2' HOUR) ";
        Pipeline pipeline1 = Pipeline.create((PipelineOptions)PipelineOptionsFactory.create());
        BeamSetOperatorRelBaseTest.compilePipeline(sql, pipeline1);
        this.pipeline.run();
    }
}

