/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamValuesRel;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class BeamEnumerableConverterTest {
    static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    static RexBuilder rexBuilder = new RexBuilder(TYPE_FACTORY);
    static PipelineOptions options = PipelineOptionsFactory.create();
    static RelOptCluster cluster = RelOptCluster.create(new VolcanoPlanner(), rexBuilder);

    @RunWith(value=Parameterized.class)
    public static class PrimitiveTypeTests {
        @Parameterized.Parameter
        public Schema.FieldType fieldType;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Schema.TypeName typeName : Schema.TypeName.values()) {
                if (!typeName.isPrimitiveType()) continue;
                builder.add((Object)new Object[]{Schema.FieldType.of((Schema.TypeName)typeName)});
            }
            ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)builder.add((Object)new Object[]{CalciteUtils.DATE})).add((Object)new Object[]{CalciteUtils.CHAR})).add((Object)new Object[]{CalciteUtils.TIME})).add((Object)new Object[]{CalciteUtils.TIME_WITH_LOCAL_TZ})).add((Object)new Object[]{CalciteUtils.TIMESTAMP})).add((Object)new Object[]{CalciteUtils.TIMESTAMP_WITH_LOCAL_TZ});
            return builder.build();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testToEnumerable_collectNullValue() {
            Schema schema = Schema.builder().addNullableField("id", this.fieldType).build();
            RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
            ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeNullLiteral(CalciteUtils.toRelDataType((RelDataTypeFactory)TYPE_FACTORY, (Schema.FieldType)this.fieldType))));
            BeamValuesRel node = new BeamValuesRel(cluster, type, tuples, null);
            Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
            Enumerator enumerator = enumerable.enumerator();
            Assert.assertTrue((boolean)enumerator.moveNext());
            Object row = enumerator.current();
            Assert.assertEquals(null, row);
            Assert.assertFalse((boolean)enumerator.moveNext());
            enumerator.close();
        }
    }

    @RunWith(value=JUnit4.class)
    public static class SpecificTypeTests {
        @Test
        public void testToEnumerable_collectSingle() {
            Schema schema = Schema.builder().addInt64Field("id").build();
            RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
            ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO)));
            BeamValuesRel node = new BeamValuesRel(cluster, type, tuples, null);
            Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
            Enumerator enumerator = enumerable.enumerator();
            Assert.assertTrue((boolean)enumerator.moveNext());
            Assert.assertEquals((Object)0L, enumerator.current());
            Assert.assertFalse((boolean)enumerator.moveNext());
            enumerator.close();
        }

        @Test
        public void testToEnumerable_collectMultiple() {
            Schema schema = Schema.builder().addInt64Field("id").addInt64Field("otherid").build();
            RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
            ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO), rexBuilder.makeBigintLiteral(BigDecimal.ONE)));
            BeamValuesRel node = new BeamValuesRel(cluster, type, tuples, null);
            Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
            Enumerator enumerator = enumerable.enumerator();
            Assert.assertTrue((boolean)enumerator.moveNext());
            Object[] row = (Object[])enumerator.current();
            Assert.assertEquals((long)2L, (long)row.length);
            Assert.assertEquals((Object)0L, (Object)row[0]);
            Assert.assertEquals((Object)1L, (Object)row[1]);
            Assert.assertFalse((boolean)enumerator.moveNext());
            enumerator.close();
        }

        @Test
        public void testToListRow_collectMultiple() {
            ImmutableList<ImmutableList<RexLiteral>> tuples;
            Schema schema = Schema.builder().addInt64Field("id").addInt64Field("otherid").build();
            RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
            BeamValuesRel node = new BeamValuesRel(cluster, type, tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO), rexBuilder.makeBigintLiteral(BigDecimal.ONE))), null);
            List rowList = BeamEnumerableConverter.toRowList((PipelineOptions)options, (BeamRelNode)node);
            Assert.assertTrue((rowList.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)Row.withSchema((Schema)schema).addValues(new Object[]{0L, 1L}).build(), rowList.get(0));
        }

        @Test
        public void testToEnumerable_count() {
            Schema schema = Schema.builder().addInt64Field("id").build();
            RelDataType type = CalciteUtils.toCalciteRowType((Schema)schema, (RelDataTypeFactory)TYPE_FACTORY);
            ImmutableList<ImmutableList<RexLiteral>> tuples = ImmutableList.of(ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ZERO)), ImmutableList.of(rexBuilder.makeBigintLiteral(BigDecimal.ONE)));
            BeamIOSinkRel node = new BeamIOSinkRel(cluster, (RelOptTable)RelOptTableImpl.create(null, type, ImmutableList.of(), null), null, (RelNode)new BeamValuesRel(cluster, type, tuples, null), null, null, null, false, (BeamSqlTable)new FakeTable(), null);
            Enumerable enumerable = BeamEnumerableConverter.toEnumerable((PipelineOptions)options, (BeamRelNode)node);
            Enumerator enumerator = enumerable.enumerator();
            Assert.assertTrue((boolean)enumerator.moveNext());
            Assert.assertEquals((Object)2L, enumerator.current());
            Assert.assertFalse((boolean)enumerator.moveNext());
            enumerator.close();
        }

        private static class FakeTable
        extends BaseBeamTable {
            public FakeTable() {
                super(null);
            }

            public PCollection.IsBounded isBounded() {
                return null;
            }

            public PCollection<Row> buildIOReader(PBegin begin) {
                return null;
            }

            public POutput buildIOWriter(PCollection<Row> input) {
                input.apply((PTransform)ParDo.of((DoFn)new DoFn<Row, Void>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext context) {
                    }
                }));
                return PDone.in((Pipeline)input.getPipeline());
            }
        }
    }
}

