/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamSqlDslExistsTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamSqlDslExistsTest.registerTable("CUSTOMER", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "c_custkey", Schema.FieldType.DOUBLE, "c_acctbal", Schema.FieldType.STRING, "c_city"}).addRows(new Object[]{1, 1.0, "Seattle", 5, 1.0, "Mountain View", 4, 4.0, "Portland"}));
        BeamSqlDslExistsTest.registerTable("ORDERS", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "o_orderkey", Schema.FieldType.INT32, "o_custkey", Schema.FieldType.DOUBLE, "o_totalprice"}).addRows(new Object[]{1, 1, 1.0, 2, 2, 2.0, 3, 3, 3.0}));
    }

    @Test
    public void testExistsSubquery() {
        String sql = "select * from CUSTOMER  where exists (  select * from ORDERS  where o_custkey = c_custkey )";
        PCollection<Row> rows = BeamSqlDslExistsTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "c_custkey", Schema.FieldType.DOUBLE, "c_acctbal", Schema.FieldType.STRING, "c_city").addRows(1, 1.0, "Seattle").getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testNotExistsSubquery() {
        String sql = "select * from CUSTOMER  where not exists (  select * from ORDERS  where o_custkey = c_custkey )";
        PCollection<Row> rows = BeamSqlDslExistsTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "c_custkey", Schema.FieldType.DOUBLE, "c_acctbal", Schema.FieldType.STRING, "c_city").addRows(4, 4.0, "Portland", 5, 1.0, "Mountain View").getRows());
        this.pipeline.run().waitUntilFinish();
    }
}

