/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.Arrays;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.Duration;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class BeamComplexTypeTest {
    private static final Schema innerRowSchema = Schema.builder().addStringField("string_field").addInt64Field("long_field").build();
    private static final Schema innerRowWithArraySchema = Schema.builder().addStringField("string_field").addArrayField("array_field", Schema.FieldType.INT64).build();
    private static final Schema nestedRowWithArraySchema = Schema.builder().addStringField("field1").addRowField("field2", innerRowWithArraySchema).addInt64Field("field3").addArrayField("field4", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    private static final Schema nestedRowSchema = Schema.builder().addStringField("nonRowfield1").addRowField("RowField", innerRowSchema).addInt64Field("nonRowfield2").addRowField("RowFieldTwo", innerRowSchema).build();
    private static final Schema rowWithArraySchema = Schema.builder().addStringField("field1").addInt64Field("field2").addArrayField("field3", Schema.FieldType.INT64).build();
    private static final Schema flattenedRowSchema = Schema.builder().addStringField("field1").addStringField("field2").addInt64Field("field3").addInt64Field("field4").addStringField("field5").addInt64Field("field6").build();
    private static final ReadOnlyTableProvider readOnlyTableProvider = new ReadOnlyTableProvider("test_provider", (Map)ImmutableMap.of((Object)"arrayWithRowTestTable", (Object)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)innerRowSchema)), "col"}).addRows(new Object[]{Arrays.asList(Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"str", 1L}).build())}), (Object)"nestedArrayTestTable", (Object)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)), "col"}).addRows(new Object[]{Arrays.asList(Arrays.asList(1L, 2L, 3L), Arrays.asList(4L, 5L))}), (Object)"nestedRowTestTable", (Object)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.row((Schema)nestedRowSchema), "col"}).addRows(new Object[]{Row.withSchema((Schema)nestedRowSchema).addValues(new Object[]{"str", Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"inner_str_one", 1L}).build(), 2L, Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"inner_str_two", 3L}).build()}).build()}), (Object)"basicRowTestTable", (Object)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.row((Schema)innerRowSchema), "col"}).addRows(new Object[]{Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"innerStr", 1L}).build()}), (Object)"rowWithArrayTestTable", (Object)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.row((Schema)rowWithArraySchema), "col"}).addRows(new Object[]{Row.withSchema((Schema)rowWithArraySchema).addValues(new Object[]{"str", 4L, Arrays.asList(5L, 6L)}).build()})));
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testNestedRow() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT nestedRowTestTable.col FROM nestedRowTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)flattenedRowSchema).addValues(new Object[]{"str", "inner_str_one", 1L, 2L, "inner_str_two", 3L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testArrayWithRow() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT arrayWithRowTestTable.col[1] FROM arrayWithRowTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"str", 1L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testNestedArray() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT nestedArrayTestTable.col[1][3], nestedArrayTestTable.col[2][1] FROM nestedArrayTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addInt64Field("field1").addInt64Field("field2").build()).addValues(new Object[]{3L, 4L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testBasicRow() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT col FROM basicRowTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)innerRowSchema).addValues(new Object[]{"innerStr", 1L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testArrayConstructor() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT ARRAY[1, 2, 3] f_arr"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addArrayField("f_arr", Schema.FieldType.INT32).build()).addValue(Arrays.asList(1, 2, 3)).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testRowWithArray() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT rowWithArrayTestTable.col.field3[2] FROM rowWithArrayTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addInt64Field("int64").build()).addValue((Object)6L).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testFieldAccessToNestedRow() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT nestedRowTestTable.col.RowField.string_field, nestedRowTestTable.col.RowFieldTwo.long_field FROM nestedRowTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addStringField("field1").addInt64Field("field2").build()).addValues(new Object[]{"inner_str_one", 3L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Ignore(value="https://issues.apache.org/jira/browse/BEAM-5189")
    @Test
    public void testSelectInnerRowOfNestedRow() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT nestedRowTestTable.col.RowField FROM nestedRowTestTable"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addStringField("field1").addInt64Field("field2").build()).addValues(new Object[]{"inner_str_one", 1L}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testRowConstructor() {
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{readOnlyTableProvider});
        PCollection stream = BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)sqlEnv.parseQuery("SELECT ROW(1, ROW(2, 3), 'str', ROW('str2', 'str3'))"));
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)Schema.builder().addInt32Field("field1").addInt32Field("field2").addInt32Field("field3").addStringField("field4").addStringField("field5").addStringField("field6").build()).addValues(new Object[]{1, 2, 3, "str", "str2", "str3"}).build()});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }
}

