/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rex;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.com.google.common.collect.Sets;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBiVisitor;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexDigestIncludeType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexVisitor;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.Litmus;

public class RexCall
extends RexNode {
    public final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    public final RelDataType type;
    private static final Set<SqlKind> SIMPLE_BINARY_OPS;

    protected RexCall(RelDataType type, SqlOperator op, List<? extends RexNode> operands) {
        this.type = Objects.requireNonNull(type);
        this.op = Objects.requireNonNull(op);
        this.operands = ImmutableList.copyOf(operands);
        assert (op.getKind() != null) : op;
        assert (op.validRexOperands(operands.size(), Litmus.THROW)) : this;
    }

    protected final StringBuilder appendOperands(StringBuilder sb) {
        for (int i = 0; i < this.operands.size(); ++i) {
            RexNode otherArg;
            RexNode operand;
            if (i > 0) {
                sb.append(", ");
            }
            if (!((operand = (RexNode)this.operands.get(i)) instanceof RexLiteral)) {
                sb.append(operand);
                continue;
            }
            RexDigestIncludeType includeType = RexDigestIncludeType.OPTIONAL;
            if ((this.isA(SqlKind.AND) || this.isA(SqlKind.OR)) && operand.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            if (SIMPLE_BINARY_OPS.contains((Object)this.getKind()) && this.operands.size() == 2 && (!((otherArg = (RexNode)this.operands.get(1 - i)) instanceof RexLiteral) || ((RexLiteral)otherArg).digestIncludesType() == RexDigestIncludeType.NO_TYPE) && RexCall.equalSansNullability(operand.getType(), otherArg.getType())) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            sb.append(((RexLiteral)operand).computeDigest(includeType));
        }
        return sb;
    }

    private static boolean equalSansNullability(RelDataType a, RelDataType b) {
        String x = a.getFullTypeString();
        String y = b.getFullTypeString();
        if (x.length() < y.length()) {
            String c = x;
            x = y;
            y = c;
        }
        return (x.length() == y.length() || x.length() == y.length() + 9 && x.endsWith(" NOT NULL")) && x.startsWith(y);
    }

    @Nonnull
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            this.appendOperands(sb);
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public final String toString() {
        String localDigest = this.digest;
        if (localDigest == null) {
            localDigest = this.computeDigest(this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION));
            this.digest = Objects.requireNonNull(localDigest);
        }
        return localDigest;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.getKind()) {
            case IS_NOT_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.getKind()) {
            case IS_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
        }
        return false;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof RexCall && this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    static {
        EnumSet<SqlKind> kinds = EnumSet.of(SqlKind.PLUS, SqlKind.MINUS, SqlKind.TIMES, SqlKind.DIVIDE);
        kinds.addAll(SqlKind.COMPARISON);
        kinds.remove((Object)SqlKind.IN);
        SIMPLE_BINARY_OPS = Sets.immutableEnumSet(kinds);
    }
}

