/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.LanguageOptions;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCatalog;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.QueryStatementConverter;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Program;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Util;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ZetaSQLPlannerImpl {
    private final @UnknownKeyFor @NonNull @Initialized SchemaPlus defaultSchemaPlus;
    private final @UnknownKeyFor @NonNull @Initialized FrameworkConfig config;
    private @UnknownKeyFor @NonNull @Initialized RelOptPlanner planner;
    private @UnknownKeyFor @NonNull @Initialized JavaTypeFactory typeFactory;
    private final @UnknownKeyFor @NonNull @Initialized RexExecutor executor;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Program> programs;
    private @UnknownKeyFor @NonNull @Initialized String defaultTimezone = "UTC";

    ZetaSQLPlannerImpl(@UnknownKeyFor @NonNull @Initialized FrameworkConfig config) {
        this.config = config;
        this.executor = config.getExecutor();
        this.programs = config.getPrograms();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            Util.discard((Object)rootSchema);
            this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
            this.planner = cluster.getPlanner();
            this.planner.setExecutor(this.executor);
            return null;
        }, (FrameworkConfig)config);
        this.defaultSchemaPlus = config.getDefaultSchema();
    }

    public @UnknownKeyFor @NonNull @Initialized RelRoot rel(@UnknownKeyFor @NonNull @Initialized String sql, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters params) {
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.typeFactory));
        AnalyzerOptions options = SqlAnalyzer.getAnalyzerOptions(params, this.defaultTimezone);
        BeamZetaSqlCatalog catalog = BeamZetaSqlCatalog.create(this.defaultSchemaPlus, (JavaTypeFactory)cluster.getTypeFactory(), options);
        SqlAnalyzer analyzer = new SqlAnalyzer();
        List<List<String>> tables = analyzer.extractTableNames(sql, options);
        TableResolution.registerTables(this.defaultSchemaPlus, tables);
        QueryTrait trait = new QueryTrait();
        catalog.addTables(tables, trait);
        ResolvedNodes.ResolvedQueryStmt statement = analyzer.analyzeQuery(sql, options, catalog);
        ExpressionConverter expressionConverter = new ExpressionConverter(cluster, params, catalog.getUserFunctionDefinitions());
        ConversionContext context = ConversionContext.of(this.config, expressionConverter, cluster, trait);
        RelNode convertedNode = QueryStatementConverter.convertRootQuery(context, statement);
        return RelRoot.of((RelNode)convertedNode, (SqlKind)SqlKind.ALL);
    }

    @UnknownKeyFor @NonNull @Initialized RelNode transform(@UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized RelTraitSet relTraitSet, @UnknownKeyFor @NonNull @Initialized RelNode relNode) {
        Program program = (Program)this.programs.get(i);
        return program.run(this.planner, relNode, relTraitSet, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    @UnknownKeyFor @NonNull @Initialized String getDefaultTimezone() {
        return this.defaultTimezone;
    }

    void setDefaultTimezone(@UnknownKeyFor @NonNull @Initialized String timezone) {
        this.defaultTimezone = timezone;
    }

    static @UnknownKeyFor @NonNull @Initialized LanguageOptions getLanguageOptions() {
        return SqlAnalyzer.baseAnalyzerOptions().getLanguageOptions();
    }
}

