/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.protobuf.ByteString;
import com.google.zetasql.ArrayType;
import com.google.zetasql.CivilTimeEncoder;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlBeamTranslationUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ZetaSqlBeamTranslationUtilsTest {
    private static final Schema TEST_INNER_SCHEMA = Schema.builder().addField("i1", Schema.FieldType.INT64).addField("i2", Schema.FieldType.STRING).build();
    private static final Schema TEST_SCHEMA = Schema.builder().addField("f_int64", Schema.FieldType.INT64).addField("f_float64", Schema.FieldType.DOUBLE).addField("f_boolean", Schema.FieldType.BOOLEAN).addField("f_string", Schema.FieldType.STRING).addField("f_bytes", Schema.FieldType.BYTES).addLogicalTypeField("f_date", SqlTypes.DATE).addLogicalTypeField("f_time", SqlTypes.TIME).addField("f_timestamp", Schema.FieldType.DATETIME).addArrayField("f_array", Schema.FieldType.DOUBLE).addRowField("f_struct", TEST_INNER_SCHEMA).addNullableField("f_null", Schema.FieldType.INT64).build();
    private static final Schema.FieldType TEST_FIELD_TYPE = Schema.FieldType.row((Schema)TEST_SCHEMA);
    private static final ArrayType TEST_INNER_ARRAY_TYPE = TypeFactory.createArrayType((Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE));
    private static final StructType TEST_INNER_STRUCT_TYPE = TypeFactory.createStructType(Arrays.asList(new StructType.StructField("i1", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64)), new StructType.StructField("i2", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING))));
    private static final StructType TEST_TYPE = TypeFactory.createStructType(Arrays.asList(new StructType.StructField("f_int64", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64)), new StructType.StructField("f_float64", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE)), new StructType.StructField("f_boolean", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL)), new StructType.StructField("f_string", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING)), new StructType.StructField("f_bytes", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES)), new StructType.StructField("f_date", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE)), new StructType.StructField("f_time", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME)), new StructType.StructField("f_timestamp", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP)), new StructType.StructField("f_array", (Type)TEST_INNER_ARRAY_TYPE), new StructType.StructField("f_struct", (Type)TEST_INNER_STRUCT_TYPE), new StructType.StructField("f_null", (Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64))));
    private static final Row TEST_ROW = Row.withSchema((Schema)TEST_SCHEMA).addValue((Object)64L).addValue((Object)5.15).addValue((Object)false).addValue((Object)"Hello").addValue((Object)new byte[]{17, 34}).addValue((Object)LocalDate.of(2020, 6, 4)).addValue((Object)LocalTime.of(15, 30, 45)).addValue((Object)Instant.ofEpochMilli((long)12345678L)).addArray(new Object[]{3.0, 6.5}).addValue((Object)Row.withSchema((Schema)TEST_INNER_SCHEMA).addValues(new Object[]{0L, "world"}).build()).addValue(null).build();
    private static final Value TEST_VALUE = Value.createStructValue((StructType)TEST_TYPE, Arrays.asList(Value.createInt64Value((long)64L), Value.createDoubleValue((double)5.15), Value.createBoolValue((boolean)false), Value.createStringValue((String)"Hello"), Value.createBytesValue((ByteString)ByteString.copyFrom((byte[])new byte[]{17, 34})), Value.createDateValue((int)((int)LocalDate.of(2020, 6, 4).toEpochDay())), Value.createTimeValue((long)CivilTimeEncoder.encodePacked64TimeNanos((LocalTime)LocalTime.of(15, 30, 45))), Value.createTimestampValueFromUnixMicros((long)12345678000L), Value.createArrayValue((ArrayType)TEST_INNER_ARRAY_TYPE, Arrays.asList(Value.createDoubleValue((double)3.0), Value.createDoubleValue((double)6.5))), Value.createStructValue((StructType)TEST_INNER_STRUCT_TYPE, Arrays.asList(Value.createInt64Value((long)0L), Value.createStringValue((String)"world"))), Value.createNullValue((Type)TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64))));

    @Test
    public void testBeamFieldTypeToZetaSqlType() {
        Assert.assertEquals((Object)ZetaSqlBeamTranslationUtils.beamFieldTypeToZetaSqlType((Schema.FieldType)TEST_FIELD_TYPE), (Object)TEST_TYPE);
    }

    @Test
    public void testJavaObjectToZetaSqlValue() {
        Assert.assertEquals((Object)ZetaSqlBeamTranslationUtils.javaObjectToZetaSqlValue((Object)TEST_ROW, (Schema.FieldType)TEST_FIELD_TYPE), (Object)TEST_VALUE);
    }

    @Test
    public void testZetaSqlValueToJavaObject() {
        Assert.assertEquals((Object)ZetaSqlBeamTranslationUtils.zetaSqlValueToJavaObject((Value)TEST_VALUE, (Schema.FieldType)TEST_FIELD_TYPE, (boolean)true), (Object)TEST_ROW);
    }
}

