/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.zetasql.TestInput;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLQueryPlanner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Context;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Contexts;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class ZetaSQLTestBase {
    protected static final Long PIPELINE_EXECUTION_WAITTIME_MINUTES = 2L;
    protected FrameworkConfig config;
    protected TableProvider tableProvider;

    protected void initializeBeamTableProvider() {
        HashMap<String, TestBoundedTable> testBoundedTableMap = new HashMap<String, TestBoundedTable>();
        testBoundedTableMap.put("KeyValue", TestInput.BASIC_TABLE_ONE);
        testBoundedTableMap.put("BigTable", TestInput.BASIC_TABLE_TWO);
        testBoundedTableMap.put("Spanner", TestInput.BASIC_TABLE_THREE);
        testBoundedTableMap.put("aggregate_test_table", TestInput.AGGREGATE_TABLE_ONE);
        testBoundedTableMap.put("window_test_table", TestInput.TIMESTAMP_TABLE_ONE);
        testBoundedTableMap.put("window_test_table_two", TestInput.TIMESTAMP_TABLE_TWO);
        testBoundedTableMap.put("all_null_table", TestInput.TABLE_ALL_NULL);
        testBoundedTableMap.put("table_with_struct", TestInput.TABLE_WITH_STRUCT);
        testBoundedTableMap.put("table_with_struct_two", TestInput.TABLE_WITH_STRUCT_TWO);
        testBoundedTableMap.put("table_with_array", TestInput.TABLE_WITH_ARRAY);
        testBoundedTableMap.put("table_with_array_for_unnest", TestInput.TABLE_WITH_ARRAY_FOR_UNNEST);
        testBoundedTableMap.put("table_for_case_when", TestInput.TABLE_FOR_CASE_WHEN);
        testBoundedTableMap.put("aggregate_test_table_two", TestInput.AGGREGATE_TABLE_TWO);
        testBoundedTableMap.put("table_empty", TestInput.TABLE_EMPTY);
        testBoundedTableMap.put("table_all_types", TestInput.TABLE_ALL_TYPES);
        testBoundedTableMap.put("table_all_types_2", TestInput.TABLE_ALL_TYPES_2);
        testBoundedTableMap.put("table_with_map", TestInput.TABLE_WITH_MAP);
        testBoundedTableMap.put("table_with_date", TestInput.TABLE_WITH_DATE);
        testBoundedTableMap.put("table_with_time", TestInput.TABLE_WITH_TIME);
        testBoundedTableMap.put("table_with_struct_ts_string", TestInput.TABLE_WITH_STRUCT_TIMESTAMP_STRING);
        testBoundedTableMap.put("streaming_sql_test_table_a", TestInput.STREAMING_SQL_TABLE_A);
        testBoundedTableMap.put("streaming_sql_test_table_b", TestInput.STREAMING_SQL_TABLE_B);
        this.tableProvider = new ReadOnlyTableProvider("test_table_provider", testBoundedTableMap);
    }

    protected void initializeCalciteEnvironment() {
        this.initializeCalciteEnvironmentWithContext(new Context[0]);
    }

    protected void initializeCalciteEnvironmentWithContext(Context ... extraContext) {
        JdbcConnection jdbcConnection = JdbcDriver.connect((TableProvider)this.tableProvider, (PipelineOptions)PipelineOptionsFactory.create());
        SchemaPlus defaultSchemaPlus = jdbcConnection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        Object[] contexts = ImmutableList.builder().add((Object)Contexts.of((Object)jdbcConnection.config())).add((Object[])extraContext).build().toArray();
        this.config = Frameworks.newConfigBuilder().defaultSchema(defaultSchemaPlus).traitDefs((List)traitDefs).context(Contexts.of((Object[])contexts)).ruleSets(ZetaSQLQueryPlanner.getZetaSqlRuleSets()).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(jdbcConnection.getTypeFactory().getTypeSystem()).build();
    }
}

