/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLQueryPlanner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Context;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Contexts;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ZetaSQLPushDownTest {
    private static final Long PIPELINE_EXECUTION_WAITTIME_MINUTES = 2L;
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt64Field("unused1").addInt64Field("id").addStringField("name").addInt64Field("unused2").build();
    private static TestTableProvider tableProvider;
    private static FrameworkConfig config;
    private static ZetaSQLQueryPlanner zetaSQLQueryPlanner;
    private static BeamSqlEnv sqlEnv;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void setUp() {
        ZetaSQLPushDownTest.initializeBeamTableProvider();
        ZetaSQLPushDownTest.initializeCalciteEnvironment();
        zetaSQLQueryPlanner = new ZetaSQLQueryPlanner(config);
        sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    @Test
    public void testProjectPushDown_withoutPredicate() {
        String sql = "SELECT name, id, unused1 FROM InMemoryTableProject";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getDigest(), (Object)zetaSqlNode.getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    @Test
    public void testProjectPushDown_withoutPredicate_withComplexSelect() {
        String sql = "SELECT id+1 FROM InMemoryTableProject";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getInput(0).getDigest(), (Object)zetaSqlNode.getInput(0).getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    @Test
    public void testProjectPushDown_withPredicate() {
        String sql = "SELECT name FROM InMemoryTableProject where id=2";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getInput(0).getDigest(), (Object)zetaSqlNode.getInput(0).getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    @Test
    public void testProjectFilterPushDown_withoutPredicate() {
        String sql = "SELECT name, id, unused1 FROM InMemoryTableBoth";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getDigest(), (Object)zetaSqlNode.getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    @Test
    public void testProjectFilterPushDown_withSupportedPredicate() {
        String sql = "SELECT name FROM InMemoryTableBoth where id=2";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode, (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getDigest(), (Object)zetaSqlNode.getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    @Test
    public void testProjectFilterPushDown_withUnsupportedPredicate() {
        String sql = "SELECT name FROM InMemoryTableBoth where id=2 or unused1=200";
        BeamRelNode zetaSqlNode = zetaSQLQueryPlanner.convertToBeamRel(sql);
        BeamRelNode calciteSqlNode = sqlEnv.parseQuery(sql);
        MatcherAssert.assertThat((Object)zetaSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)calciteSqlNode.getInput(0), (Matcher)Matchers.instanceOf(BeamIOSourceRel.class));
        Assert.assertEquals((Object)calciteSqlNode.getInput(0).getDigest(), (Object)zetaSqlNode.getInput(0).getDigest());
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)PIPELINE_EXECUTION_WAITTIME_MINUTES));
    }

    private static void initializeCalciteEnvironment() {
        ZetaSQLPushDownTest.initializeCalciteEnvironmentWithContext(new Context[0]);
    }

    private static void initializeCalciteEnvironmentWithContext(Context ... extraContext) {
        JdbcConnection jdbcConnection = JdbcDriver.connect((TableProvider)tableProvider, (PipelineOptions)PipelineOptionsFactory.create());
        SchemaPlus defaultSchemaPlus = jdbcConnection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        Object[] contexts = ImmutableList.builder().add((Object)Contexts.of((Object)jdbcConnection.config())).add((Object[])extraContext).build().toArray();
        config = Frameworks.newConfigBuilder().defaultSchema(defaultSchemaPlus).traitDefs((List)traitDefs).context(Contexts.of((Object[])contexts)).ruleSets(ZetaSQLQueryPlanner.getZetaSqlRuleSets()).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(jdbcConnection.getTypeFactory().getTypeSystem()).build();
    }

    private static void initializeBeamTableProvider() {
        Table projectTable = ZetaSQLPushDownTest.getTable("InMemoryTableProject", TestTableProvider.PushDownOptions.PROJECT);
        Table bothTable = ZetaSQLPushDownTest.getTable("InMemoryTableBoth", TestTableProvider.PushDownOptions.BOTH);
        Row[] rows = new Row[]{ZetaSQLPushDownTest.row(BASIC_SCHEMA, 100L, 1L, "one", 100L), ZetaSQLPushDownTest.row(BASIC_SCHEMA, 200L, 2L, "two", 200L)};
        tableProvider = new TestTableProvider();
        tableProvider.createTable(projectTable);
        tableProvider.createTable(bothTable);
        tableProvider.addRows(projectTable.getName(), rows);
        tableProvider.addRows(bothTable.getName(), rows);
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }
}

