/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class TableResolutionTest {
    @Mock
    SchemaPlus mockSchemaPlus;
    @Mock
    SchemaPlus innerSchemaPlus;
    @Mock
    Table mockTable;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testResolveFlat() {
        String tableName = "fake_table";
        Mockito.when((Object)this.mockSchemaPlus.getTable(tableName)).thenReturn((Object)this.mockTable);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.is((Object)this.mockTable));
    }

    @Test
    public void testResolveWithDots() {
        String tableName = "fake.table";
        Mockito.when((Object)this.mockSchemaPlus.getTable(tableName)).thenReturn((Object)this.mockTable);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.is((Object)this.mockTable));
    }

    @Test
    public void testMissingFlat() {
        String tableName = "fake_table";
        Mockito.when((Object)this.mockSchemaPlus.getTable(tableName)).thenReturn(null);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testResolveNested() {
        String subSchema = "fake_schema";
        String tableName = "fake_table";
        Mockito.when((Object)this.mockSchemaPlus.getSubSchema(subSchema)).thenReturn((Object)this.innerSchemaPlus);
        Mockito.when((Object)this.innerSchemaPlus.getTable(tableName)).thenReturn((Object)this.mockTable);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)subSchema, (Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.is((Object)this.mockTable));
    }

    @Test
    public void testResolveNestedWithDots() {
        String subSchema = "fake.schema";
        String tableName = "fake.table";
        Mockito.when((Object)this.mockSchemaPlus.getSubSchema(subSchema)).thenReturn((Object)this.innerSchemaPlus);
        Mockito.when((Object)this.innerSchemaPlus.getTable(tableName)).thenReturn((Object)this.mockTable);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)subSchema, (Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.is((Object)this.mockTable));
    }

    @Test
    public void testMissingSubschema() {
        String subSchema = "fake_schema";
        String tableName = "fake_table";
        Mockito.when((Object)this.mockSchemaPlus.getSubSchema(subSchema)).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)subSchema, (Object)tableName)));
    }

    @Test
    public void testMissingTableInSubschema() {
        String subSchema = "fake_schema";
        String tableName = "fake_table";
        Mockito.when((Object)this.mockSchemaPlus.getSubSchema(subSchema)).thenReturn((Object)this.innerSchemaPlus);
        Mockito.when((Object)this.innerSchemaPlus.getTable(tableName)).thenReturn(null);
        Table table = TableResolution.resolveCalciteTable((SchemaPlus)this.mockSchemaPlus, (List)ImmutableList.of((Object)subSchema, (Object)tableName));
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.nullValue());
    }
}

