/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class BigQueryPerfTable
extends BigQueryTable {
    private final String namespace;
    private final String metric;

    BigQueryPerfTable(Table table, BigQueryUtils.ConversionOptions options, String namespace, String metric) {
        super(table, options);
        this.namespace = namespace;
        this.metric = metric;
    }

    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)super.buildIOReader(begin).apply((PTransform)ParDo.of((DoFn)new RowMonitor(this.namespace, this.metric)));
    }

    public PCollection<Row> buildIOReader(PBegin begin, BeamSqlTableFilter filters, List<String> fieldNames) {
        return (PCollection)super.buildIOReader(begin, filters, fieldNames).apply((PTransform)ParDo.of((DoFn)new RowMonitor(this.namespace, this.metric)));
    }

    private static class RowMonitor
    extends DoFn<Row, Row> {
        private Counter totalRows;

        RowMonitor(String namespace, String name) {
            this.totalRows = Metrics.counter((String)namespace, (String)name);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.totalRows.inc((long)((Row)c.element()).getFieldCount());
            c.output((Object)((Row)c.element()));
        }
    }
}

