/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.google.cloud.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOPushDownRule;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryPerfTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.metrics.IOITMetrics;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.testutils.metrics.TimeMonitor;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.tools.RuleSets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOPushDownIT {
    private static final String READ_FROM_TABLE = "apache-beam-testing:beam_performance.hacker_news_full";
    private static final String NAMESPACE = BigQueryIOPushDownIT.class.getName();
    private static final String FIELDS_READ_METRIC = "fields_read";
    private static final String READ_TIME_METRIC = "read_time";
    private static final String CREATE_TABLE_STATEMENT = "CREATE EXTERNAL TABLE HACKER_NEWS( \n   title VARCHAR, \n   url VARCHAR, \n   text VARCHAR, \n   dead BOOLEAN, \n   `by` VARCHAR, \n   score INTEGER, \n   `time` INTEGER, \n   `timestamp` TIMESTAMP, \n   type VARCHAR, \n   id INTEGER, \n   parent INTEGER, \n   descendants INTEGER, \n   ranking INTEGER, \n   deleted BOOLEAN \n) \nTYPE 'bigquery' \nLOCATION 'apache-beam-testing:beam_performance.hacker_news_full' \nTBLPROPERTIES '{ method: \"%s\" }'";
    private static final String SELECT_STATEMENT = "SELECT `by` as author, type, title, score from HACKER_NEWS where (type='story' or type='job') and score>2";
    private static SQLBigQueryPerfTestOptions options;
    private static String metricsBigQueryDataset;
    private static String metricsBigQueryTable;
    private static InfluxDBSettings settings;
    private Pipeline pipeline = Pipeline.create((PipelineOptions)options);
    private BeamSqlEnv sqlEnv;

    @BeforeClass
    public static void setUp() {
        options = (SQLBigQueryPerfTestOptions)IOITHelper.readIOTestPipelineOptions(SQLBigQueryPerfTestOptions.class);
        metricsBigQueryDataset = options.getMetricsBigQueryDataset();
        metricsBigQueryTable = options.getMetricsBigQueryTable();
        settings = InfluxDBSettings.builder().withHost(options.getInfluxHost()).withDatabase(options.getInfluxDatabase()).withMeasurement(options.getInfluxMeasurement()).get();
    }

    @Before
    public void before() {
        this.sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigQueryPerfTableProvider(NAMESPACE, FIELDS_READ_METRIC)});
    }

    @Test
    public void readUsingDirectReadMethodPushDown() {
        this.sqlEnv.executeDdl(String.format(CREATE_TABLE_STATEMENT, BigQueryIO.TypedRead.Method.DIRECT_READ.toString()));
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(SELECT_STATEMENT);
        PCollection output = (PCollection)BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode).apply((PTransform)ParDo.of((DoFn)new TimeMonitor(NAMESPACE, READ_TIME_METRIC)));
        PipelineResult result = this.pipeline.run();
        result.waitUntilFinish();
        this.collectAndPublishMetrics(result, "_directread_pushdown");
    }

    @Test
    public void readUsingDirectReadMethod() {
        ArrayList ruleList = new ArrayList();
        for (RuleSet x : BeamRuleSets.getRuleSets()) {
            x.iterator().forEachRemaining(ruleList::add);
        }
        ruleList.remove(BeamIOPushDownRule.INSTANCE);
        InMemoryMetaStore inMemoryMetaStore = new InMemoryMetaStore();
        inMemoryMetaStore.registerProvider((TableProvider)new BigQueryPerfTableProvider(NAMESPACE, FIELDS_READ_METRIC));
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)inMemoryMetaStore).setPipelineOptions(PipelineOptionsFactory.create()).setRuleSets((Collection)ImmutableList.of((Object)RuleSets.ofList(ruleList))).build();
        this.sqlEnv.executeDdl(String.format(CREATE_TABLE_STATEMENT, BigQueryIO.TypedRead.Method.DIRECT_READ.toString()));
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(SELECT_STATEMENT);
        PCollection output = (PCollection)BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode).apply((PTransform)ParDo.of((DoFn)new TimeMonitor(NAMESPACE, READ_TIME_METRIC)));
        PipelineResult result = this.pipeline.run();
        result.waitUntilFinish();
        this.collectAndPublishMetrics(result, "_directread");
    }

    @Test
    public void readUsingDefaultMethod() {
        this.sqlEnv.executeDdl(String.format(CREATE_TABLE_STATEMENT, BigQueryIO.TypedRead.Method.DEFAULT.toString()));
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(SELECT_STATEMENT);
        PCollection output = (PCollection)BeamSqlRelUtils.toPCollection((Pipeline)this.pipeline, (BeamRelNode)beamRelNode).apply((PTransform)ParDo.of((DoFn)new TimeMonitor(NAMESPACE, READ_TIME_METRIC)));
        PipelineResult result = this.pipeline.run();
        result.waitUntilFinish();
        this.collectAndPublishMetrics(result, "_default");
    }

    private void collectAndPublishMetrics(PipelineResult readResult, String postfix) {
        String uuid = UUID.randomUUID().toString();
        String timestamp = Timestamp.now().toString();
        Set<Function<MetricsReader, NamedTestResult>> readSuppliers = this.getReadSuppliers(uuid, timestamp);
        IOITMetrics readMetrics = new IOITMetrics(readSuppliers, readResult, NAMESPACE, uuid, timestamp);
        readMetrics.publish(metricsBigQueryDataset, metricsBigQueryTable + postfix);
        readMetrics.publishToInflux(settings.copyWithMeasurement(BigQueryIOPushDownIT.settings.measurement + postfix));
    }

    private Set<Function<MetricsReader, NamedTestResult>> getReadSuppliers(String uuid, String timestamp) {
        HashSet<Function<MetricsReader, NamedTestResult>> suppliers = new HashSet<Function<MetricsReader, NamedTestResult>>();
        suppliers.add(reader -> {
            long readStart = reader.getStartTimeMetric(READ_TIME_METRIC);
            long readEnd = reader.getEndTimeMetric(READ_TIME_METRIC);
            return NamedTestResult.create((String)uuid, (String)timestamp, (String)READ_TIME_METRIC, (double)((double)(readEnd - readStart) / 1000.0));
        });
        suppliers.add(reader -> {
            long fieldsRead = reader.getCounterMetric(FIELDS_READ_METRIC);
            return NamedTestResult.create((String)uuid, (String)timestamp, (String)FIELDS_READ_METRIC, (double)fieldsRead);
        });
        return suppliers;
    }

    public static interface SQLBigQueryPerfTestOptions
    extends IOTestPipelineOptions {
        @Description(value="BQ dataset for the metrics data")
        public String getMetricsBigQueryDataset();

        public void setMetricsBigQueryDataset(String var1);

        @Description(value="BQ table for metrics data")
        public String getMetricsBigQueryTable();

        public void setMetricsBigQueryTable(String var1);
    }
}

