/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog;

import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog.AutoValue_HCatalogTable;
import org.apache.beam.sdk.io.hcatalog.HCatToRow;
import org.apache.beam.sdk.io.hcatalog.HCatalogIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@AutoValue
@Experimental
public abstract class HCatalogTable
extends BaseBeamTable {
    public abstract Schema schema();

    public abstract Map<String, String> config();

    public abstract String database();

    public abstract String table();

    public PCollection<Row> buildIOReader(PBegin begin) {
        return (PCollection)begin.apply("HCatalog-Read-" + this.database() + "-" + this.table(), HCatToRow.fromSpec((HCatalogIO.Read)HCatalogIO.read().withConfigProperties(this.config()).withDatabase(this.database()).withTable(this.table())));
    }

    public POutput buildIOWriter(PCollection<Row> input) {
        throw new UnsupportedOperationException("Writing to HCatalog is not supported in Beam SQL");
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    public Schema getSchema() {
        return this.schema();
    }

    static Builder builder() {
        return new AutoValue_HCatalogTable.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setSchema(Schema var1);

        abstract Builder setConfig(Map<String, String> var1);

        abstract Builder setDatabase(String var1);

        abstract Builder setTable(String var1);

        abstract HCatalogTable build();
    }
}

