/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog.HCatalogTable;
import org.apache.beam.sdk.io.hcatalog.HCatalogBeamSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DatabaseProvider
implements TableProvider {
    private @UnknownKeyFor @NonNull @Initialized String db;
    private @UnknownKeyFor @NonNull @Initialized HCatalogBeamSchema metastoreSchema;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config;

    DatabaseProvider(@UnknownKeyFor @NonNull @Initialized String db, @UnknownKeyFor @NonNull @Initialized HCatalogBeamSchema metastoreSchema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> config) {
        this.db = db;
        this.metastoreSchema = metastoreSchema;
        this.config = config;
    }

    @UnknownKeyFor @NonNull @Initialized String getDb() {
        return this.db;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "hcatalog";
    }

    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported in HCatalog");
    }

    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        throw new UnsupportedOperationException("Deleting tables is not supported in HCatalog");
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        throw new UnsupportedOperationException("Listing tables is not supported in HCatalog");
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String table) {
        Optional tableSchema = this.metastoreSchema.getTableSchema(this.db, table);
        if (!tableSchema.isPresent()) {
            return null;
        }
        return Table.builder().schema((Schema)tableSchema.get()).name(table).location("").properties(new JSONObject()).comment("").type("hcatalog").build();
    }

    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        return HCatalogTable.builder().setConfig(this.config).setDatabase(this.db).setTable(table.getName()).setSchema(table.getSchema()).build();
    }
}

