/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog.HCatalogTable;
import org.apache.beam.sdk.io.hcatalog.HCatalogBeamSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

class DatabaseProvider
implements TableProvider {
    private String db;
    private HCatalogBeamSchema metastoreSchema;
    private Map<String, String> config;

    DatabaseProvider(String db, HCatalogBeamSchema metastoreSchema, Map<String, String> config) {
        this.db = db;
        this.metastoreSchema = metastoreSchema;
        this.config = config;
    }

    String getDb() {
        return this.db;
    }

    public String getTableType() {
        return "hcatalog";
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported in HCatalog");
    }

    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("Deleting tables is not supported in HCatalog");
    }

    public Map<String, Table> getTables() {
        throw new UnsupportedOperationException("Listing tables is not supported in HCatalog");
    }

    public @Nullable Table getTable(String table) {
        Optional tableSchema = this.metastoreSchema.getTableSchema(this.db, table);
        if (!tableSchema.isPresent()) {
            return null;
        }
        return Table.builder().schema((Schema)tableSchema.get()).name(table).location("").properties(new JSONObject()).comment("").type("hcatalog").build();
    }

    public BeamSqlTable buildBeamSqlTable(Table table) {
        return HCatalogTable.builder().setConfig(this.config).setDatabase(this.db).setTable(table.getName()).setSchema(table.getSchema()).build();
    }
}

