/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ZetaSqlIdUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZetaSqlIdUtilsTest {
    @Test
    public void testHandlesSimpleIds() {
        List<String> id = Arrays.asList("aaa", "BbB", "zAzzz00");
        Assert.assertEquals((Object)"aaa.BbB.zAzzz00", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }

    @Test
    public void testHandlesMixedIds() {
        List<String> id = Arrays.asList("aaa", "Bb---B", "zAzzz00");
        Assert.assertEquals((Object)"aaa.`Bb---B`.zAzzz00", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }

    @Test
    public void testHandlesSpecialChars() {
        List<String> id = Arrays.asList("a\\a", "b`b", "c'c", "d\"d", "e?e");
        Assert.assertEquals((Object)"`a\\\\a`.`b\\`b`.`c\\'c`.`d\\\"d`.`e\\?e`", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }

    @Test
    public void testHandlesSpecialCharsInOnePart() {
        List<String> id = Arrays.asList("a\\ab`bc'cd\"de?e");
        Assert.assertEquals((Object)"`a\\\\ab\\`bc\\'cd\\\"de\\?e`", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }

    @Test
    public void testHandlesWhiteSpaces() {
        List<String> id = Arrays.asList("a\na", "b\tb", "c\rc", "d\fd");
        Assert.assertEquals((Object)"`a\\na`.`b\\tb`.`c\\rc`.`d\\fd`", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }

    @Test
    public void testHandlesWhiteSpacesInOnePart() {
        List<String> id = Arrays.asList("a\nab\tbc\rcd\fd");
        Assert.assertEquals((Object)"`a\\nab\\tbc\\rcd\\fd`", (Object)ZetaSqlIdUtils.escapeAndJoin(id));
    }
}

