/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ZetaSqlIdUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Pattern SPECIAL_CHARS_ESCAPE = Pattern.compile("(?<SpecialChar>[\\\\`'\"?])");
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> WHITESPACES = ImmutableMap.of((Object)"\n", (Object)"\\\\n", (Object)"\t", (Object)"\\\\t", (Object)"\r", (Object)"\\\\r", (Object)"\f", (Object)"\\\\f");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern SIMPLE_ID = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");

    ZetaSqlIdUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized String escapeAndJoin(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parts) {
        return parts.stream().map(ZetaSqlIdUtils::escapeSpecialChars).map(ZetaSqlIdUtils::replaceWhitespaces).map(ZetaSqlIdUtils::backtickIfNeeded).collect(Collectors.joining("."));
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeSpecialChars(@UnknownKeyFor @NonNull @Initialized String str) {
        return SPECIAL_CHARS_ESCAPE.matcher(str).replaceAll("\\\\${SpecialChar}");
    }

    private static @UnknownKeyFor @NonNull @Initialized String replaceWhitespaces(@UnknownKeyFor @NonNull @Initialized String s) {
        return WHITESPACES.keySet().stream().reduce(s, (str, whitespace) -> str.replaceAll((String)whitespace, (String)Preconditions.checkNotNull((Object)((String)WHITESPACES.get(whitespace)))));
    }

    private static @UnknownKeyFor @NonNull @Initialized String backtickIfNeeded(@UnknownKeyFor @NonNull @Initialized String s) {
        return SIMPLE_ID.matcher(s).matches() ? s : "`" + s + "`";
    }
}

