/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.cloud.datacatalog.v1beta1.Entry;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.sql.TableUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryTableFactory
implements TableFactory {
    private static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_API = "bigquery.googleapis.com";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern BQ_PATH_PATTERN = Pattern.compile("/projects/(?<PROJECT>[^/]+)/datasets/(?<DATASET>[^/]+)/tables/(?<TABLE>[^/]+)");
    private final @UnknownKeyFor @NonNull @Initialized boolean truncateTimestamps;

    public BigQueryTableFactory(@UnknownKeyFor @NonNull @Initialized boolean truncateTimestamps) {
        this.truncateTimestamps = truncateTimestamps;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Table.Builder> tableBuilder(@UnknownKeyFor @NonNull @Initialized Entry entry) {
        if (!URI.create(entry.getLinkedResource()).getAuthority().equalsIgnoreCase(BIGQUERY_API)) {
            return Optional.empty();
        }
        return Optional.of(Table.builder().location(BigQueryTableFactory.getLocation(entry)).properties(TableUtils.emptyProperties().put("truncateTimestamps", this.truncateTimestamps)).type("bigquery").comment(""));
    }

    private static @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized Entry entry) {
        URI entryName = URI.create(entry.getLinkedResource());
        String bqPath = entryName.getPath();
        Matcher bqPathMatcher = BQ_PATH_PATTERN.matcher(bqPath);
        if (!bqPathMatcher.matches()) {
            throw new IllegalArgumentException("Unsupported format for BigQuery table path: '" + entry.getLinkedResource() + "'");
        }
        String project = bqPathMatcher.group("PROJECT");
        String dataset = bqPathMatcher.group("DATASET");
        String table = bqPathMatcher.group("TABLE");
        return String.format("%s:%s.%s", project, dataset, table);
    }
}

