/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.alibaba.fastjson.JSONObject;
import com.google.cloud.datacatalog.v1beta1.Entry;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PubsubTableFactory
implements TableFactory {
    private static final @UnknownKeyFor @NonNull @Initialized String PUBSUB_API = "pubsub.googleapis.com";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern PS_PATH_PATTERN = Pattern.compile("/projects/(?<PROJECT>[^/]+)/topics/(?<TOPIC>[^/]+)");

    PubsubTableFactory() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Table.Builder> tableBuilder(@UnknownKeyFor @NonNull @Initialized Entry entry) {
        if (!URI.create(entry.getLinkedResource()).getAuthority().equalsIgnoreCase(PUBSUB_API)) {
            return Optional.empty();
        }
        return Optional.of(Table.builder().location(PubsubTableFactory.getLocation(entry)).properties(new JSONObject()).type("pubsub").comment(""));
    }

    private static @UnknownKeyFor @NonNull @Initialized String getLocation(@UnknownKeyFor @NonNull @Initialized Entry entry) {
        URI entryName = URI.create(entry.getLinkedResource());
        String psPath = entryName.getPath();
        Matcher bqPathMatcher = PS_PATH_PATTERN.matcher(psPath);
        if (!bqPathMatcher.matches()) {
            throw new IllegalArgumentException("Unsupported format for Pubsub topic: '" + entry.getLinkedResource() + "'");
        }
        return psPath.substring(1);
    }
}

