/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.alibaba.fastjson.JSONObject;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec;
import com.google.protobuf.ProtocolStringList;
import java.util.Optional;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class GcsTableFactory
implements TableFactory {
    GcsTableFactory() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Table.Builder> tableBuilder(@UnknownKeyFor @NonNull @Initialized Entry entry) {
        if (!entry.hasGcsFilesetSpec()) {
            return Optional.empty();
        }
        GcsFilesetSpec gcsFilesetSpec = entry.getGcsFilesetSpec();
        ProtocolStringList filePatterns = gcsFilesetSpec.getFilePatternsList();
        if (filePatterns.size() != 1) {
            throw new UnsupportedOperationException("Unable to parse GCS entry '" + entry.getName() + "'");
        }
        String filePattern = (String)filePatterns.get(0);
        if (!filePattern.startsWith("gs://")) {
            throw new UnsupportedOperationException("Unsupported file pattern. Only file patterns with 'gs://' schema are supported at the moment.");
        }
        return Optional.of(Table.builder().type("text").location(filePattern).properties(new JSONObject()).comment(""));
    }
}

