/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogTableProvider;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamSqlDataCatalogExample {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamSqlDataCatalogExample.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LOG.info("Args: {}", Arrays.asList(args));
        DCExamplePipelineOptions options = (DCExamplePipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(DCExamplePipelineOptions.class);
        LOG.info("Query: {}\nOutput: {}", (Object)options.getQueryString(), (Object)options.getOutputFilePrefix());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        BeamSqlDataCatalogExample.validateArgs(options);
        try (DataCatalogTableProvider tableProvider = DataCatalogTableProvider.create((DataCatalogPipelineOptions)options.as(DataCatalogPipelineOptions.class));){
            ((PCollection)((PCollection)pipeline.apply("SQL Query", (PTransform)SqlTransform.query((String)options.getQueryString()).withDefaultTableProvider("datacatalog", (TableProvider)tableProvider))).apply("Convert to Strings", BeamSqlDataCatalogExample.rowsToStrings())).apply("Write output", (PTransform)TextIO.write().to(options.getOutputFilePrefix()));
            pipeline.run().waitUntilFinish();
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized MapElements<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized String> rowsToStrings() {
        return MapElements.into((TypeDescriptor)TypeDescriptor.of(String.class)).via((SerializableFunction & Serializable)row -> row.getValues().stream().map(String::valueOf).collect(Collectors.joining(", ")));
    }

    private static void validateArgs(@UnknownKeyFor @NonNull @Initialized DCExamplePipelineOptions options) {
        if (Strings.isNullOrEmpty((String)options.getQueryString()) || Strings.isNullOrEmpty((String)options.getOutputFilePrefix())) {
            String usage = "ERROR: SQL query or output file is not specified.To run this example:\n./gradlew :sdks:java:extensions:sql:datacatalog:runDataCatalogExample -PgcpProject=<project> -PgcsTempRoot=<GCS temp location> -PqueryString=<query> -PoutputFilePrefix=<output location> -PtempLocation=<temp GCS location for BQ export>\n\n";
            throw new IllegalArgumentException(usage);
        }
    }

    public static interface DCExamplePipelineOptions
    extends PipelineOptions {
        @Description(value="Required. SQL Query containing the pipeline logic.")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getQueryString();

        public void setQueryString(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Required. Output file prefix.")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutputFilePrefix();

        public void setOutputFilePrefix(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

