/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.datacatalog.v1beta1.DataCatalogClient;
import com.google.cloud.datacatalog.v1beta1.DataCatalogSettings;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.LookupEntryRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryRequest;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.FullNameTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.BigQueryTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ChainedTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.GcsTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.PubsubTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.SchemaUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ZetaSqlIdUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class DataCatalogTableProvider
extends FullNameTableProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogTableProvider.class);
    private static final TableFactory PUBSUB_TABLE_FACTORY = new PubsubTableFactory();
    private static final TableFactory GCS_TABLE_FACTORY = new GcsTableFactory();
    private static final Map<String, TableProvider> DELEGATE_PROVIDERS = Stream.of(new PubsubTableProvider(), new BigQueryTableProvider(), new TextTableProvider()).collect(Collectors.toMap(TableProvider::getTableType, p -> p));
    private final DataCatalogClient dataCatalog;
    private final Map<String, Table> tableCache = new HashMap<String, Table>();
    private final TableFactory tableFactory;

    private DataCatalogTableProvider(DataCatalogClient dataCatalog, boolean truncateTimestamps) {
        this.dataCatalog = dataCatalog;
        this.tableFactory = ChainedTableFactory.of(PUBSUB_TABLE_FACTORY, GCS_TABLE_FACTORY, new BigQueryTableFactory(truncateTimestamps));
    }

    public static DataCatalogTableProvider create(DataCatalogPipelineOptions options) {
        return new DataCatalogTableProvider(DataCatalogTableProvider.createDataCatalogClient(options), options.getTruncateTimestamps());
    }

    public String getTableType() {
        return "google.cloud.datacatalog";
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported with DataCatalog table provider.");
    }

    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("Dropping tables is not supported with DataCatalog table provider");
    }

    public Map<String, Table> getTables() {
        throw new UnsupportedOperationException("Loading all tables from DataCatalog is not supported");
    }

    public @Nullable Table getTable(String tableName) {
        return this.loadTable(tableName);
    }

    public Table getTableByFullName(TableName fullTableName) {
        ImmutableList allNameParts = ImmutableList.builder().addAll((Iterable)fullTableName.getPath()).add((Object)fullTableName.getTableName()).build();
        String fullEscapedTableName = ZetaSqlIdUtils.escapeAndJoin((List<String>)allNameParts);
        return this.loadTable(fullEscapedTableName);
    }

    public BeamSqlTable buildBeamSqlTable(Table table) {
        TableProvider tableProvider = DELEGATE_PROVIDERS.get(table.getType());
        if (tableProvider == null) {
            throw new RuntimeException("TableProvider is null");
        }
        return tableProvider.buildBeamSqlTable(table);
    }

    private Table loadTable(String tableName) {
        if (!this.tableCache.containsKey(tableName)) {
            this.tableCache.put(tableName, this.loadTableFromDC(tableName));
        }
        return this.tableCache.get(tableName);
    }

    private Table loadTableFromDC(String tableName) {
        try {
            return this.toCalciteTable(tableName, this.dataCatalog.lookupEntry(LookupEntryRequest.newBuilder().setSqlResource(tableName).build()));
        }
        catch (InvalidArgumentException | NotFoundException | PermissionDeniedException e) {
            throw new InvalidTableException("Could not resolve table in Data Catalog: " + tableName, e);
        }
    }

    @Internal
    public static DataCatalogClient createDataCatalogClient(DataCatalogPipelineOptions options) {
        try {
            DataCatalogSettings.Builder builder = (DataCatalogSettings.Builder)((DataCatalogSettings.Builder)DataCatalogSettings.newBuilder().setCredentialsProvider(() -> ((GcpOptions)options.as(GcpOptions.class)).getGcpCredential())).setEndpoint(options.getDataCatalogEndpoint());
            builder.lookupEntrySettings().setRetryableCodes((Set)ImmutableSet.of((Object)StatusCode.Code.PERMISSION_DENIED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE)).setRetrySettings(builder.lookupEntrySettings().getRetrySettings().toBuilder().setMaxRetryDelay(Duration.ofMinutes((long)1L)).build());
            builder.updateEntrySettings().setRetryableCodes((Set)ImmutableSet.of((Object)StatusCode.Code.PERMISSION_DENIED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE)).setRetrySettings(builder.updateEntrySettings().getRetrySettings().toBuilder().setMaxRetryDelay(Duration.ofMinutes((long)1L)).build());
            return DataCatalogClient.create((DataCatalogSettings)builder.build());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Data Catalog client", e);
        }
    }

    private Table toCalciteTable(String tableName, Entry entry) {
        if (entry.getSchema().getColumnsCount() == 0) {
            throw new UnsupportedOperationException("Entry doesn't have a schema. Please attach a schema to '" + tableName + "' in Data Catalog: " + entry.toString());
        }
        Schema schema = SchemaUtils.fromDataCatalog(entry.getSchema());
        Optional<Table.Builder> tableBuilder = this.tableFactory.tableBuilder(entry);
        if (!tableBuilder.isPresent()) {
            throw new UnsupportedOperationException(String.format("Unsupported Data Catalog entry: %s", MoreObjects.toStringHelper((Object)entry).add("linkedResource", (Object)entry.getLinkedResource()).add("hasGcsFilesetSpec", entry.hasGcsFilesetSpec()).toString()));
        }
        return tableBuilder.get().schema(schema).name(tableName).build();
    }

    @Internal
    public boolean setSchemaIfNotPresent(String resource, Schema schema) {
        com.google.cloud.datacatalog.v1beta1.Schema dcSchema = SchemaUtils.toDataCatalog(schema);
        Entry entry = this.dataCatalog.lookupEntry(LookupEntryRequest.newBuilder().setSqlResource(resource).build());
        if (entry.getSchema().getColumnsCount() == 0) {
            this.dataCatalog.updateEntry(UpdateEntryRequest.newBuilder().setEntry(entry.toBuilder().setSchema(dcSchema).build()).setUpdateMask(FieldMask.newBuilder().addPaths("schema").build()).build());
            return true;
        }
        LOG.info(String.format("Not updating schema for '%s' since it already has one.", resource));
        return false;
    }

    @Override
    public void close() {
        this.dataCatalog.close();
    }
}

