/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.cloud.datacatalog.v1beta1.ColumnSchema;
import com.google.cloud.datacatalog.v1beta1.Schema;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaUtils {
    private static final Map<String, Schema.FieldType> FIELD_TYPES = ImmutableMap.builder().put((Object)"BOOL", (Object)Schema.FieldType.BOOLEAN).put((Object)"BYTES", (Object)Schema.FieldType.BYTES).put((Object)"DATE", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE)).put((Object)"DATETIME", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).put((Object)"DOUBLE", (Object)Schema.FieldType.DOUBLE).put((Object)"FLOAT", (Object)Schema.FieldType.DOUBLE).put((Object)"FLOAT64", (Object)Schema.FieldType.DOUBLE).put((Object)"INT32", (Object)Schema.FieldType.INT32).put((Object)"INT64", (Object)Schema.FieldType.INT64).put((Object)"STRING", (Object)Schema.FieldType.STRING).put((Object)"TIME", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).put((Object)"TIMESTAMP", (Object)Schema.FieldType.DATETIME).put((Object)"NUMERIC", (Object)Schema.FieldType.DECIMAL).put((Object)"MAP<STRING,STRING>", (Object)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.STRING)).build();

    SchemaUtils() {
    }

    static Schema fromDataCatalog(com.google.cloud.datacatalog.v1beta1.Schema dcSchema) {
        return SchemaUtils.fromColumnsList(dcSchema.getColumnsList());
    }

    private static Schema fromColumnsList(List<ColumnSchema> columnsMap) {
        return (Schema)columnsMap.stream().map(SchemaUtils::toBeamField).collect(Schema.toSchema());
    }

    private static Schema.Field toBeamField(ColumnSchema column) {
        String name = column.getColumn();
        Schema.FieldType fieldType = SchemaUtils.getBeamFieldType(column);
        Schema.Field field = Schema.Field.of((String)name, (Schema.FieldType)fieldType);
        if (Strings.isNullOrEmpty((String)column.getMode()) || "NULLABLE".equals(column.getMode())) {
            field = field.withNullable(true);
        } else if ("REQUIRED".equals(column.getMode())) {
            field = field.withNullable(false);
        } else if ("REPEATED".equals(column.getMode())) {
            field = Schema.Field.of((String)name, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)fieldType));
        } else {
            throw new UnsupportedOperationException("Field mode '" + column.getMode() + "' is not supported (field '" + name + "')");
        }
        return field;
    }

    private static Schema.FieldType getBeamFieldType(ColumnSchema column) {
        String dcFieldType = column.getType();
        if (FIELD_TYPES.containsKey(dcFieldType)) {
            return FIELD_TYPES.get(dcFieldType);
        }
        if ("STRUCT".equals(dcFieldType)) {
            Schema structSchema = SchemaUtils.fromColumnsList(column.getSubcolumnsList());
            return Schema.FieldType.row((Schema)structSchema);
        }
        throw new UnsupportedOperationException("Field type '" + dcFieldType + "' is not supported (field '" + column.getColumn() + "')");
    }

    static com.google.cloud.datacatalog.v1beta1.Schema toDataCatalog(Schema schema) {
        Schema.Builder schemaBuilder = com.google.cloud.datacatalog.v1beta1.Schema.newBuilder();
        for (Schema.Field field : schema.getFields()) {
            schemaBuilder.addColumns(SchemaUtils.fromBeamField(field));
        }
        return schemaBuilder.build();
    }

    private static ColumnSchema fromBeamField(Schema.Field field) {
        Schema.FieldType fieldType = field.getType();
        if (fieldType.getTypeName().equals((Object)Schema.TypeName.ARRAY)) {
            if (fieldType.getNullable().booleanValue()) {
                throw new UnsupportedOperationException("Nullable array type is not supported in DataCatalog schemas: " + fieldType);
            }
            if (fieldType.getCollectionElementType().getNullable().booleanValue()) {
                throw new UnsupportedOperationException("Nullable array element type is not supported in DataCatalog schemas: " + fieldType);
            }
            if (fieldType.getCollectionElementType().getTypeName().equals((Object)Schema.TypeName.ARRAY)) {
                throw new UnsupportedOperationException("Array of arrays not supported in DataCatalog schemas: " + fieldType);
            }
            ColumnSchema column = SchemaUtils.fromBeamField(Schema.Field.of((String)field.getName(), (Schema.FieldType)fieldType.getCollectionElementType()));
            if (!column.getMode().equals("REQUIRED")) {
                throw new AssertionError((Object)("ColumnSchema for collection element type has non-empty mode: " + fieldType));
            }
            return column.toBuilder().setMode("REPEATED").build();
        }
        ColumnSchema.Builder colBuilder = ColumnSchema.newBuilder().setType(SchemaUtils.getDataCatalogType(fieldType));
        if (fieldType.getNullable().booleanValue()) {
            colBuilder.setMode("NULLABLE");
        } else {
            colBuilder.setMode("REQUIRED");
        }
        if (fieldType.getTypeName().equals((Object)Schema.TypeName.ROW)) {
            for (Schema.Field subField : fieldType.getRowSchema().getFields()) {
                colBuilder.addSubcolumns(SchemaUtils.fromBeamField(subField));
            }
        }
        return colBuilder.setColumn(field.getName()).build();
    }

    private static String getDataCatalogType(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: 
            case INT64: 
            case BYTES: 
            case DOUBLE: 
            case STRING: {
                return fieldType.getTypeName().name();
            }
            case BOOLEAN: {
                return "BOOL";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case DECIMAL: {
                return "NUMERIC";
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logical = fieldType.getLogicalType();
                if (SqlTypes.TIME.getIdentifier().equals(logical.getIdentifier())) {
                    return "TIME";
                }
                if (SqlTypes.DATE.getIdentifier().equals(logical.getIdentifier())) {
                    return "DATE";
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(logical.getIdentifier())) {
                    return "DATETIME";
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + logical);
            }
            case ROW: {
                return "STRUCT";
            }
            case MAP: {
                return String.format("MAP<%s,%s>", SchemaUtils.getDataCatalogType(fieldType.getMapKeyType()), SchemaUtils.getDataCatalogType(fieldType.getMapValueType()));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }
}

