/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.cloud.datacatalog.v1beta1.ColumnSchema;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> FIELD_TYPES = ImmutableMap.builder().put((Object)"BOOL", (Object)Schema.FieldType.BOOLEAN).put((Object)"BYTES", (Object)Schema.FieldType.BYTES).put((Object)"DATE", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE)).put((Object)"DATETIME", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME)).put((Object)"DOUBLE", (Object)Schema.FieldType.DOUBLE).put((Object)"FLOAT", (Object)Schema.FieldType.DOUBLE).put((Object)"FLOAT64", (Object)Schema.FieldType.DOUBLE).put((Object)"INT32", (Object)Schema.FieldType.INT32).put((Object)"INT64", (Object)Schema.FieldType.INT64).put((Object)"STRING", (Object)Schema.FieldType.STRING).put((Object)"TIME", (Object)Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME)).put((Object)"TIMESTAMP", (Object)Schema.FieldType.DATETIME).put((Object)"NUMERIC", (Object)Schema.FieldType.DECIMAL).put((Object)"MAP<STRING,STRING>", (Object)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.STRING)).build();

    SchemaUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized Schema fromDataCatalog(@UnknownKeyFor @NonNull @Initialized com.google.cloud.datacatalog.v1beta1.Schema dcSchema) {
        return SchemaUtils.fromColumnsList(dcSchema.getColumnsList());
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema fromColumnsList(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ColumnSchema> columnsMap) {
        return (Schema)columnsMap.stream().map(SchemaUtils::toBeamField).collect(Schema.toSchema());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field toBeamField(@UnknownKeyFor @NonNull @Initialized ColumnSchema column) {
        String name = column.getColumn();
        Schema.FieldType fieldType = SchemaUtils.getBeamFieldType(column);
        Schema.Field field = Schema.Field.of((String)name, (Schema.FieldType)fieldType);
        if (Strings.isNullOrEmpty((String)column.getMode()) || "NULLABLE".equals(column.getMode())) {
            field = field.withNullable(true);
        } else if ("REQUIRED".equals(column.getMode())) {
            field = field.withNullable(false);
        } else if ("REPEATED".equals(column.getMode())) {
            field = Schema.Field.of((String)name, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)fieldType));
        } else {
            throw new UnsupportedOperationException("Field mode '" + column.getMode() + "' is not supported (field '" + name + "')");
        }
        return field;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBeamFieldType(@UnknownKeyFor @NonNull @Initialized ColumnSchema column) {
        String dcFieldType = column.getType();
        if (FIELD_TYPES.containsKey(dcFieldType)) {
            return FIELD_TYPES.get(dcFieldType);
        }
        if ("STRUCT".equals(dcFieldType)) {
            Schema structSchema = SchemaUtils.fromColumnsList(column.getSubcolumnsList());
            return Schema.FieldType.row((Schema)structSchema);
        }
        throw new UnsupportedOperationException("Field type '" + dcFieldType + "' is not supported (field '" + column.getColumn() + "')");
    }
}

