/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.datacatalog.v1beta1.DataCatalogClient;
import com.google.cloud.datacatalog.v1beta1.DataCatalogSettings;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.LookupEntryRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.FullNameTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.BigQueryTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ChainedTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.GcsTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.PubsubTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.SchemaUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ZetaSqlIdUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataCatalogTableProvider
extends FullNameTableProvider
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized TableFactory PUBSUB_TABLE_FACTORY = new PubsubTableFactory();
    private static final @UnknownKeyFor @NonNull @Initialized TableFactory GCS_TABLE_FACTORY = new GcsTableFactory();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> DELEGATE_PROVIDERS = Stream.of(new PubsubTableProvider(), new BigQueryTableProvider(), new TextTableProvider()).collect(Collectors.toMap(TableProvider::getTableType, p -> p));
    private final @UnknownKeyFor @NonNull @Initialized DataCatalogClient dataCatalog;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> tableCache = new HashMap<String, Table>();
    private final @UnknownKeyFor @NonNull @Initialized TableFactory tableFactory;

    private DataCatalogTableProvider(@UnknownKeyFor @NonNull @Initialized DataCatalogClient dataCatalog, @UnknownKeyFor @NonNull @Initialized boolean truncateTimestamps) {
        this.dataCatalog = dataCatalog;
        this.tableFactory = ChainedTableFactory.of(PUBSUB_TABLE_FACTORY, GCS_TABLE_FACTORY, new BigQueryTableFactory(truncateTimestamps));
    }

    public static @UnknownKeyFor @NonNull @Initialized DataCatalogTableProvider create(@UnknownKeyFor @NonNull @Initialized DataCatalogPipelineOptions options) {
        return new DataCatalogTableProvider(DataCatalogTableProvider.createDataCatalogClient(options), options.getTruncateTimestamps());
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "google.cloud.datacatalog";
    }

    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported with DataCatalog table provider.");
    }

    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        throw new UnsupportedOperationException("Dropping tables is not supported with DataCatalog table provider");
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        throw new UnsupportedOperationException("Loading all tables from DataCatalog is not supported");
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        return this.loadTable(tableName);
    }

    public @UnknownKeyFor @NonNull @Initialized Table getTableByFullName(@UnknownKeyFor @NonNull @Initialized TableName fullTableName) {
        ImmutableList allNameParts = ImmutableList.builder().addAll((Iterable)fullTableName.getPath()).add((Object)fullTableName.getTableName()).build();
        String fullEscapedTableName = ZetaSqlIdUtils.escapeAndJoin((List<String>)allNameParts);
        return this.loadTable(fullEscapedTableName);
    }

    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        TableProvider tableProvider = DELEGATE_PROVIDERS.get(table.getType());
        if (tableProvider == null) {
            throw new RuntimeException("TableProvider is null");
        }
        return tableProvider.buildBeamSqlTable(table);
    }

    private @UnknownKeyFor @NonNull @Initialized Table loadTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        if (!this.tableCache.containsKey(tableName)) {
            this.tableCache.put(tableName, this.loadTableFromDC(tableName));
        }
        return this.tableCache.get(tableName);
    }

    private @UnknownKeyFor @NonNull @Initialized Table loadTableFromDC(@UnknownKeyFor @NonNull @Initialized String tableName) {
        try {
            return this.toCalciteTable(tableName, this.dataCatalog.lookupEntry(LookupEntryRequest.newBuilder().setSqlResource(tableName).build()));
        }
        catch (InvalidArgumentException | NotFoundException | PermissionDeniedException e) {
            throw new InvalidTableException("Could not resolve table in Data Catalog: " + tableName, e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized DataCatalogClient createDataCatalogClient(@UnknownKeyFor @NonNull @Initialized DataCatalogPipelineOptions options) {
        try {
            return DataCatalogClient.create((DataCatalogSettings)((DataCatalogSettings.Builder)((DataCatalogSettings.Builder)DataCatalogSettings.newBuilder().setCredentialsProvider(() -> ((GcpOptions)options.as(GcpOptions.class)).getGcpCredential())).setEndpoint(options.getDataCatalogEndpoint())).build());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Data Catalog client", e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Table toCalciteTable(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized Entry entry) {
        if (entry.getSchema().getColumnsCount() == 0) {
            throw new UnsupportedOperationException("Entry doesn't have a schema. Please attach a schema to '" + tableName + "' in Data Catalog: " + entry.toString());
        }
        Schema schema = SchemaUtils.fromDataCatalog(entry.getSchema());
        Optional<Table.Builder> tableBuilder = this.tableFactory.tableBuilder(entry);
        if (!tableBuilder.isPresent()) {
            throw new UnsupportedOperationException(String.format("Unsupported Data Catalog entry: %s", MoreObjects.toStringHelper((Object)entry).add("linkedResource", (Object)entry.getLinkedResource()).add("hasGcsFilesetSpec", entry.hasGcsFilesetSpec()).toString()));
        }
        return tableBuilder.get().schema(schema).name(tableName).build();
    }

    @Override
    public void close() {
        this.dataCatalog.close();
    }
}

