/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class ZetaSqlIdUtils {
    private static final Pattern SPECIAL_CHARS_ESCAPE = Pattern.compile("(?<SpecialChar>[\\\\`'\"?])");
    private static final ImmutableMap<String, String> WHITESPACES = ImmutableMap.of((Object)"\n", (Object)"\\\\n", (Object)"\t", (Object)"\\\\t", (Object)"\r", (Object)"\\\\r", (Object)"\f", (Object)"\\\\f");
    private static final Pattern SIMPLE_ID = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");

    ZetaSqlIdUtils() {
    }

    static String escapeAndJoin(List<String> parts) {
        return parts.stream().map(ZetaSqlIdUtils::escapeSpecialChars).map(ZetaSqlIdUtils::replaceWhitespaces).map(ZetaSqlIdUtils::backtickIfNeeded).collect(Collectors.joining("."));
    }

    private static String escapeSpecialChars(String str) {
        return SPECIAL_CHARS_ESCAPE.matcher(str).replaceAll("\\\\${SpecialChar}");
    }

    private static String replaceWhitespaces(String s) {
        return WHITESPACES.keySet().stream().reduce(s, (str, whitespace) -> str.replaceAll((String)whitespace, (String)WHITESPACES.get(whitespace)));
    }

    private static String backtickIfNeeded(String s) {
        return SIMPLE_ID.matcher(s).matches() ? s : "`" + s + "`";
    }
}

