/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.auth.Credentials;
import com.google.cloud.datacatalog.DataCatalogGrpc;
import com.google.cloud.datacatalog.Entry;
import com.google.cloud.datacatalog.LookupEntryRequest;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.auth.MoreCallCredentials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.FullNameTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.BigQueryTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ChainedTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.GcsTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.PubsubTableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.SchemaUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.ZetaSqlIdUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubJsonTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

public class DataCatalogTableProvider
extends FullNameTableProvider {
    private static final TableFactory PUBSUB_TABLE_FACTORY = new PubsubTableFactory();
    private static final TableFactory GCS_TABLE_FACTORY = new GcsTableFactory();
    private static final Map<String, TableProvider> DELEGATE_PROVIDERS = Stream.of(new PubsubJsonTableProvider(), new BigQueryTableProvider(), new TextTableProvider()).collect(Collectors.toMap(TableProvider::getTableType, p -> p));
    private final DataCatalogGrpc.DataCatalogBlockingStub dataCatalog;
    private final Map<String, Table> tableCache = new HashMap<String, Table>();
    private final TableFactory tableFactory;

    private DataCatalogTableProvider(DataCatalogGrpc.DataCatalogBlockingStub dataCatalog, boolean truncateTimestamps) {
        this.dataCatalog = dataCatalog;
        this.tableFactory = ChainedTableFactory.of(PUBSUB_TABLE_FACTORY, GCS_TABLE_FACTORY, new BigQueryTableFactory(truncateTimestamps));
    }

    public static DataCatalogTableProvider create(DataCatalogPipelineOptions options) {
        return new DataCatalogTableProvider(DataCatalogTableProvider.createDataCatalogClient(options), options.getTruncateTimestamps());
    }

    public String getTableType() {
        return "google.cloud.datacatalog";
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported with DataCatalog table provider.");
    }

    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("Dropping tables is not supported with DataCatalog table provider");
    }

    public Map<String, Table> getTables() {
        throw new UnsupportedOperationException("Loading all tables from DataCatalog is not supported");
    }

    @Nullable
    public Table getTable(String tableName) {
        return this.loadTable(tableName);
    }

    @Nullable
    public Table getTableByFullName(TableName fullTableName) {
        ImmutableList allNameParts = ImmutableList.builder().addAll((Iterable)fullTableName.getPath()).add((Object)fullTableName.getTableName()).build();
        String fullEscapedTableName = ZetaSqlIdUtils.escapeAndJoin((List<String>)allNameParts);
        return this.loadTable(fullEscapedTableName);
    }

    public BeamSqlTable buildBeamSqlTable(Table table) {
        return DELEGATE_PROVIDERS.get(table.getType()).buildBeamSqlTable(table);
    }

    @Nullable
    private Table loadTable(String tableName) {
        if (!this.tableCache.containsKey(tableName)) {
            this.tableCache.put(tableName, this.loadTableFromDC(tableName));
        }
        return this.tableCache.get(tableName);
    }

    private Table loadTableFromDC(String tableName) {
        try {
            return this.toCalciteTable(tableName, this.dataCatalog.lookupEntry(LookupEntryRequest.newBuilder().setSqlResource(tableName).build()));
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().equals((Object)Status.INVALID_ARGUMENT)) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    private static DataCatalogGrpc.DataCatalogBlockingStub createDataCatalogClient(DataCatalogPipelineOptions options) {
        return (DataCatalogGrpc.DataCatalogBlockingStub)DataCatalogGrpc.newBlockingStub((Channel)ManagedChannelBuilder.forTarget((String)options.getDataCatalogEndpoint()).build()).withCallCredentials(MoreCallCredentials.from((Credentials)((GcpOptions)options.as(GcpOptions.class)).getGcpCredential()));
    }

    private Table toCalciteTable(String tableName, Entry entry) {
        if (entry.getSchema().getColumnsCount() == 0) {
            throw new UnsupportedOperationException("Entry doesn't have a schema. Please attach a schema to '" + tableName + "' in Data Catalog: " + entry.toString());
        }
        Schema schema = SchemaUtils.fromDataCatalog(entry.getSchema());
        Optional<Table.Builder> tableBuilder = this.tableFactory.tableBuilder(entry);
        if (!tableBuilder.isPresent()) {
            throw new UnsupportedOperationException(String.format("Unsupported Data Catalog entry: %s", MoreObjects.toStringHelper((Object)entry).add("linkedResource", (Object)entry.getLinkedResource()).add("hasGcsFilesetSpec", entry.hasGcsFilesetSpec()).toString()));
        }
        return tableBuilder.get().schema(schema).name(tableName).build();
    }
}

