/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.cloud.datacatalog.Entry;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;

class ChainedTableFactory
implements TableFactory {
    private final List<TableFactory> subTableFactories;

    public static ChainedTableFactory of(TableFactory ... subTableFactories) {
        return new ChainedTableFactory(Arrays.asList(subTableFactories));
    }

    private ChainedTableFactory(List<TableFactory> subTableFactories) {
        this.subTableFactories = subTableFactories;
    }

    @Override
    public Optional<Table.Builder> tableBuilder(Entry entry) {
        for (TableFactory tableFactory : this.subTableFactories) {
            Optional<Table.Builder> tableBuilder = tableFactory.tableBuilder(entry);
            if (!tableBuilder.isPresent()) continue;
            return tableBuilder;
        }
        return Optional.empty();
    }
}

