/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.alibaba.fastjson.JSONObject;
import com.google.cloud.datacatalog.Entry;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.TableFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class BigQueryTableFactory
implements TableFactory {
    private static final String BIGQUERY_API = "bigquery.googleapis.com";
    private static final Pattern BQ_PATH_PATTERN = Pattern.compile("/projects/(?<PROJECT>[^/]+)/datasets/(?<DATASET>[^/]+)/tables/(?<TABLE>[^/]+)");
    private final boolean truncateTimestamps;

    public BigQueryTableFactory(boolean truncateTimestamps) {
        this.truncateTimestamps = truncateTimestamps;
    }

    @Override
    public Optional<Table.Builder> tableBuilder(Entry entry) {
        if (!URI.create(entry.getLinkedResource()).getAuthority().toLowerCase().equals(BIGQUERY_API)) {
            return Optional.empty();
        }
        return Optional.of(Table.builder().location(BigQueryTableFactory.getLocation(entry)).properties(new JSONObject((Map)ImmutableMap.of((Object)"truncateTimestamps", (Object)this.truncateTimestamps))).type("bigquery").comment(""));
    }

    private static String getLocation(Entry entry) {
        URI entryName = URI.create(entry.getLinkedResource());
        String bqPath = entryName.getPath();
        Matcher bqPathMatcher = BQ_PATH_PATTERN.matcher(bqPath);
        if (!bqPathMatcher.matches()) {
            throw new IllegalArgumentException("Unsupported format for BigQuery table path: '" + entry.getLinkedResource() + "'");
        }
        String project = bqPathMatcher.group("PROJECT");
        String dataset = bqPathMatcher.group("DATASET");
        String table = bqPathMatcher.group("TABLE");
        return String.format("%s:%s.%s", project, dataset, table);
    }
}

