/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import java.io.Serializable;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataCatalogGCSIT
implements Serializable {
    private static final Schema ID_NAME_TYPE_SCHEMA = Schema.builder().addNullableField("id", Schema.FieldType.INT32).addNullableField("name", Schema.FieldType.STRING).addNullableField("type", Schema.FieldType.STRING).build();
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testReadFromGCS() throws Exception {
        String gcsEntryId = "`datacatalog`.`entry`.`apache-beam-testing`.`us-central1`.`samples`.`integ_test_small_csv_test_1`";
        PCollection result = (PCollection)this.pipeline.apply("query", (PTransform)SqlTransform.query((String)("SELECT id, name, type FROM " + gcsEntryId)).withDefaultTableProvider("dc", (TableProvider)DataCatalogTableProvider.create((DataCatalogPipelineOptions)((DataCatalogPipelineOptions)this.pipeline.getOptions().as(DataCatalogPipelineOptions.class)))));
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(true);
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "customer1", "test"), this.row(2, "customer2", "test"), this.row(3, "customer1", "test"), this.row(4, "customer2", "test")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private Row row(int id, String name, String type) {
        return Row.withSchema((Schema)ID_NAME_TYPE_SCHEMA).addValues(new Object[]{id, name, type}).build();
    }
}

