/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog;

import com.google.api.services.bigquery.model.TableReference;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogPipelineOptions;
import org.apache.beam.sdk.extensions.sql.meta.provider.datacatalog.DataCatalogTableProvider;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLQueryPlanner;
import org.apache.beam.sdk.io.gcp.bigquery.TestBigQuery;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class DataCatalogBigQueryIT {

    @RunWith(value=Parameterized.class)
    public static class DialectSensitiveTests {
        private static final Schema ID_NAME_SCHEMA = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("name", Schema.FieldType.STRING).build();
        @Rule
        public transient TestPipeline readPipeline = TestPipeline.create();
        @Rule
        public transient TestBigQuery bigQuery = TestBigQuery.create((Schema)ID_NAME_SCHEMA);
        @Parameterized.Parameter(value=0)
        public String dialectName;
        @Parameterized.Parameter(value=1)
        public Class<? extends QueryPlanner> queryPlanner;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> dialects() {
            return Arrays.asList({"ZetaSQL", ZetaSQLQueryPlanner.class}, {"CalciteSQL", CalciteQueryPlanner.class});
        }

        @Test
        public void testRead() throws Exception {
            this.bigQuery.insertRows(ID_NAME_SCHEMA, new Row[]{DialectSensitiveTests.row(1L, "name1"), DialectSensitiveTests.row(2L, "name2"), DialectSensitiveTests.row(3L, "name3")});
            TableReference bqTable = this.bigQuery.tableReference();
            String tableId = String.format("bigquery.`table`.`%s`.`%s`.`%s`", bqTable.getProjectId(), bqTable.getDatasetId(), bqTable.getTableId());
            ((BeamSqlPipelineOptions)this.readPipeline.getOptions().as(BeamSqlPipelineOptions.class)).setPlannerName(this.queryPlanner.getCanonicalName());
            PCollection result = (PCollection)this.readPipeline.apply("query", (PTransform)SqlTransform.query((String)("SELECT id, name FROM " + tableId)).withDefaultTableProvider("datacatalog", (TableProvider)DataCatalogTableProvider.create((DataCatalogPipelineOptions)((DataCatalogPipelineOptions)this.readPipeline.getOptions().as(DataCatalogPipelineOptions.class)))));
            PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{DialectSensitiveTests.row(1L, "name1"), DialectSensitiveTests.row(2L, "name2"), DialectSensitiveTests.row(3L, "name3")});
            this.readPipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
        }

        private static Row row(long id, String name) {
            return Row.withSchema((Schema)ID_NAME_SCHEMA).addValues(new Object[]{id, name}).build();
        }
    }
}

