/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sketching.com.google.common.base.Preconditions;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sketching.AutoValue_ApproximateDistinct_GloballyDistinct;
import org.apache.beam.sdk.extensions.sketching.AutoValue_ApproximateDistinct_PerKeyDistinct;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

@Experimental
public final class ApproximateDistinct {
    public static <InputT> GloballyDistinct<InputT> globally() {
        return GloballyDistinct.builder().build();
    }

    public static <K, V> PerKeyDistinct<K, V> perKey() {
        return PerKeyDistinct.builder().build();
    }

    public static long precisionForRelativeError(double relativeError) {
        return Math.round(Math.ceil(Math.log(Math.pow(1.106, 2.0) / Math.pow(relativeError, 2.0)) / Math.log(2.0)));
    }

    public static double relativeErrorForPrecision(int p) {
        double betaM;
        if (p < 4) {
            return 1.0;
        }
        switch (p) {
            case 4: {
                betaM = 1.156;
                break;
            }
            case 5: {
                betaM = 1.2;
                break;
            }
            case 6: {
                betaM = 1.104;
                break;
            }
            case 7: {
                betaM = 1.096;
                break;
            }
            default: {
                betaM = 1.05;
            }
        }
        return betaM / Math.sqrt(Math.exp((double)p * Math.log(2.0)));
    }

    private static class RetrieveCardinality {
        private RetrieveCardinality() {
        }

        private static <K> DoFn<KV<K, HyperLogLogPlus>, KV<K, Long>> perKey() {
            return new DoFn<KV<K, HyperLogLogPlus>, KV<K, Long>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV kv = (KV)c.element();
                    c.output((Object)KV.of((Object)kv.getKey(), (Object)((HyperLogLogPlus)kv.getValue()).cardinality()));
                }
            };
        }

        private static DoFn<HyperLogLogPlus, Long> globally() {
            return new DoFn<HyperLogLogPlus, Long>(){

                @DoFn.ProcessElement
                public void apply(DoFn.ProcessContext c) {
                    c.output((Object)((HyperLogLogPlus)c.element()).cardinality());
                }
            };
        }
    }

    public static class HyperLogLogPlusCoder
    extends CustomCoder<HyperLogLogPlus> {
        private static final HyperLogLogPlusCoder INSTANCE = new HyperLogLogPlusCoder();
        private static final ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

        public static HyperLogLogPlusCoder of() {
            return INSTANCE;
        }

        public void encode(HyperLogLogPlus value, OutputStream outStream) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null HyperLogLogPlus sketch");
            }
            BYTE_ARRAY_CODER.encode(value.getBytes(), outStream);
        }

        public HyperLogLogPlus decode(InputStream inStream) throws IOException {
            return HyperLogLogPlus.Builder.build((byte[])BYTE_ARRAY_CODER.decode(inStream));
        }

        public boolean isRegisterByteSizeObserverCheap(HyperLogLogPlus value) {
            return true;
        }

        protected long getEncodedElementByteSize(HyperLogLogPlus value) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null HyperLogLogPlus sketch");
            }
            return value.sizeof();
        }
    }

    public static class ApproximateDistinctFn<InputT>
    extends Combine.CombineFn<InputT, HyperLogLogPlus, HyperLogLogPlus> {
        private final int p;
        private final int sp;
        private final Coder<InputT> inputCoder;

        private ApproximateDistinctFn(int p, int sp, Coder<InputT> coder) {
            this.p = p;
            this.sp = sp;
            this.inputCoder = coder;
        }

        public static <InputT> ApproximateDistinctFn<InputT> create(Coder<InputT> coder) {
            try {
                coder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException("Coder must be deterministic to perform this sketch." + e.getMessage(), e);
            }
            return new ApproximateDistinctFn<InputT>(12, 0, coder);
        }

        public ApproximateDistinctFn<InputT> withPrecision(int p) {
            Preconditions.checkArgument(p >= 4, "Expected: p >= 4. Actual: p = %s", p);
            return new ApproximateDistinctFn<InputT>(p, this.sp, this.inputCoder);
        }

        public ApproximateDistinctFn<InputT> withSparseRepresentation(int sp) {
            Preconditions.checkArgument(sp > this.p && sp < 32 || sp == 0, "Expected: p <= sp <= 32.Actual: p = %s, sp = %s", this.p, sp);
            return new ApproximateDistinctFn<InputT>(this.p, sp, this.inputCoder);
        }

        public HyperLogLogPlus createAccumulator() {
            return new HyperLogLogPlus(this.p, this.sp);
        }

        public HyperLogLogPlus addInput(HyperLogLogPlus acc, InputT record) {
            try {
                acc.offer((Object)CoderUtils.encodeToByteArray(this.inputCoder, record));
            }
            catch (CoderException e) {
                throw new IllegalStateException("The input value cannot be encoded: " + e.getMessage(), e);
            }
            return acc;
        }

        public HyperLogLogPlus extractOutput(HyperLogLogPlus accumulator) {
            return accumulator;
        }

        public HyperLogLogPlus mergeAccumulators(Iterable<HyperLogLogPlus> accumulators) {
            HyperLogLogPlus mergedAccum = this.createAccumulator();
            for (HyperLogLogPlus accum : accumulators) {
                try {
                    mergedAccum.addAll(accum);
                }
                catch (CardinalityMergeException e) {
                    throw new IllegalStateException("The accumulators cannot be merged: " + e.getMessage(), e);
                }
            }
            return mergedAccum;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"p", (Integer)this.p).withLabel("precision")).add(DisplayData.item((String)"sp", (Integer)this.sp).withLabel("sparse representation precision"));
        }
    }

    @AutoValue
    public static abstract class PerKeyDistinct<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        abstract int precision();

        abstract int sparsePrecision();

        abstract Builder<K, V> toBuilder();

        static <K, V> Builder<K, V> builder() {
            return new AutoValue_ApproximateDistinct_PerKeyDistinct.Builder().setPrecision(12).setSparsePrecision(0);
        }

        public PerKeyDistinct<K, V> withPrecision(int p) {
            return this.toBuilder().setPrecision(p).build();
        }

        public PerKeyDistinct<K, V> withSparsePrecision(int sp) {
            return this.toBuilder().setSparsePrecision(sp).build();
        }

        public PCollection<KV<K, Long>> expand(PCollection<KV<K, V>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return (PCollection)((PCollection)input.apply((PTransform)Combine.perKey(ApproximateDistinctFn.create(inputCoder.getValueCoder()).withPrecision(this.precision()).withSparseRepresentation(this.sparsePrecision())))).apply("Retrieve Cardinality", (PTransform)ParDo.of((DoFn)RetrieveCardinality.perKey()));
        }

        @AutoValue.Builder
        static abstract class Builder<K, V> {
            Builder() {
            }

            abstract Builder<K, V> setPrecision(int var1);

            abstract Builder<K, V> setSparsePrecision(int var1);

            abstract PerKeyDistinct<K, V> build();
        }
    }

    @AutoValue
    public static abstract class GloballyDistinct<InputT>
    extends PTransform<PCollection<InputT>, PCollection<Long>> {
        abstract int precision();

        abstract int sparsePrecision();

        abstract Builder<InputT> toBuilder();

        static <InputT> Builder<InputT> builder() {
            return new AutoValue_ApproximateDistinct_GloballyDistinct.Builder().setPrecision(12).setSparsePrecision(0);
        }

        public GloballyDistinct<InputT> withPrecision(int p) {
            return this.toBuilder().setPrecision(p).build();
        }

        public GloballyDistinct<InputT> withSparsePrecision(int sp) {
            return this.toBuilder().setSparsePrecision(sp).build();
        }

        public PCollection<Long> expand(PCollection<InputT> input) {
            return (PCollection)((PCollection)input.apply("Compute HyperLogLog Structure", (PTransform)Combine.globally(ApproximateDistinctFn.create(input.getCoder()).withPrecision(this.precision()).withSparseRepresentation(this.sparsePrecision())))).apply("Retrieve Cardinality", (PTransform)ParDo.of((DoFn)RetrieveCardinality.globally()));
        }

        @AutoValue.Builder
        static abstract class Builder<InputT> {
            Builder() {
            }

            abstract Builder<InputT> setPrecision(int var1);

            abstract Builder<InputT> setSparsePrecision(int var1);

            abstract GloballyDistinct<InputT> build();
        }
    }
}

