/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sketching.AutoValue_ApproximateDistinct_GloballyDistinct;
import org.apache.beam.sdk.extensions.sketching.AutoValue_ApproximateDistinct_PerKeyDistinct;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ApproximateDistinct {
    public static <InputT> @UnknownKeyFor @NonNull @Initialized GloballyDistinct<InputT> globally() {
        return GloballyDistinct.builder().build();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKeyDistinct<K, V> perKey() {
        return PerKeyDistinct.builder().build();
    }

    public static @UnknownKeyFor @NonNull @Initialized long precisionForRelativeError(@UnknownKeyFor @NonNull @Initialized double relativeError) {
        return Math.round(Math.ceil(Math.log(Math.pow(1.106, 2.0) / Math.pow(relativeError, 2.0)) / Math.log(2.0)));
    }

    public static @UnknownKeyFor @NonNull @Initialized double relativeErrorForPrecision(@UnknownKeyFor @NonNull @Initialized int p) {
        double betaM;
        if (p < 4) {
            return 1.0;
        }
        switch (p) {
            case 4: {
                betaM = 1.156;
                break;
            }
            case 5: {
                betaM = 1.2;
                break;
            }
            case 6: {
                betaM = 1.104;
                break;
            }
            case 7: {
                betaM = 1.096;
                break;
            }
            default: {
                betaM = 1.05;
            }
        }
        return betaM / Math.sqrt(Math.exp((double)p * Math.log(2.0)));
    }

    private static class RetrieveCardinality {
        private RetrieveCardinality() {
        }

        private static <K> @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus>, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> perKey() {
            return new DoFn<KV<K, HyperLogLogPlus>, KV<K, Long>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    KV kv = (KV)c.element();
                    c.output((Object)KV.of((Object)kv.getKey(), (Object)((HyperLogLogPlus)kv.getValue()).cardinality()));
                }
            };
        }

        private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus, @UnknownKeyFor @NonNull @Initialized Long> globally() {
            return new DoFn<HyperLogLogPlus, Long>(){

                @DoFn.ProcessElement
                public void apply(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output((Object)((HyperLogLogPlus)c.element()).cardinality());
                }
            };
        }
    }

    public static class HyperLogLogPlusCoder
    extends CustomCoder<HyperLogLogPlus> {
        private static final @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusCoder INSTANCE = new HyperLogLogPlusCoder();
        private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

        public static @UnknownKeyFor @NonNull @Initialized HyperLogLogPlusCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null HyperLogLogPlus sketch");
            }
            BYTE_ARRAY_CODER.encode(value.getBytes(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return HyperLogLogPlus.Builder.build((byte[])BYTE_ARRAY_CODER.decode(inStream));
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus value) {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null HyperLogLogPlus sketch");
            }
            return value.sizeof();
        }
    }

    public static class ApproximateDistinctFn<@UnknownKeyFor InputT>
    extends Combine.CombineFn<InputT, HyperLogLogPlus, HyperLogLogPlus> {
        private final @UnknownKeyFor @NonNull @Initialized int p;
        private final @UnknownKeyFor @NonNull @Initialized int sp;
        private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;

        private ApproximateDistinctFn(@UnknownKeyFor @NonNull @Initialized int p, @UnknownKeyFor @NonNull @Initialized int sp, @UnknownKeyFor @NonNull @Initialized Coder<InputT> coder) {
            this.p = p;
            this.sp = sp;
            this.inputCoder = coder;
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized ApproximateDistinctFn<InputT> create(@UnknownKeyFor @NonNull @Initialized Coder<InputT> coder) {
            try {
                coder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException("Coder must be deterministic to perform this sketch." + e.getMessage(), e);
            }
            return new ApproximateDistinctFn<InputT>(12, 0, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized ApproximateDistinctFn<InputT> withPrecision(@UnknownKeyFor @NonNull @Initialized int p) {
            Preconditions.checkArgument((p >= 4 ? 1 : 0) != 0, (String)"Expected: p >= 4. Actual: p = %s", (int)p);
            return new ApproximateDistinctFn<InputT>(p, this.sp, this.inputCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized ApproximateDistinctFn<InputT> withSparseRepresentation(@UnknownKeyFor @NonNull @Initialized int sp) {
            Preconditions.checkArgument((sp > this.p && sp < 32 || sp == 0 ? 1 : 0) != 0, (String)"Expected: p <= sp <= 32.Actual: p = %s, sp = %s", (int)this.p, (int)sp);
            return new ApproximateDistinctFn<InputT>(this.p, sp, this.inputCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus createAccumulator() {
            return new HyperLogLogPlus(this.p, this.sp);
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus addInput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus acc, InputT record) {
            try {
                acc.offer((Object)CoderUtils.encodeToByteArray(this.inputCoder, record));
            }
            catch (CoderException e) {
                throw new IllegalStateException("The input value cannot be encoded: " + e.getMessage(), e);
            }
            return acc;
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus extractOutput(@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus accumulator) {
            return accumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized HyperLogLogPlus mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized HyperLogLogPlus> accumulators) {
            HyperLogLogPlus mergedAccum = this.createAccumulator();
            for (HyperLogLogPlus accum : accumulators) {
                try {
                    mergedAccum.addAll(accum);
                }
                catch (CardinalityMergeException e) {
                    throw new IllegalStateException("The accumulators cannot be merged: " + e.getMessage(), e);
                }
            }
            return mergedAccum;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"p", (Integer)this.p).withLabel("precision")).add(DisplayData.item((String)"sp", (Integer)this.sp).withLabel("sparse representation precision"));
        }
    }

    @AutoValue
    public static abstract class PerKeyDistinct<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Long>>> {
        abstract @UnknownKeyFor @NonNull @Initialized int precision();

        abstract @UnknownKeyFor @NonNull @Initialized int sparsePrecision();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> toBuilder();

        static <K, V> @UnknownKeyFor @NonNull @Initialized Builder<K, V> builder() {
            return new AutoValue_ApproximateDistinct_PerKeyDistinct.Builder().setPrecision(12).setSparsePrecision(0);
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeyDistinct<K, V> withPrecision(@UnknownKeyFor @NonNull @Initialized int p) {
            return this.toBuilder().setPrecision(p).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeyDistinct<K, V> withSparsePrecision(@UnknownKeyFor @NonNull @Initialized int sp) {
            return this.toBuilder().setSparsePrecision(sp).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return (PCollection)((PCollection)input.apply((PTransform)Combine.perKey(ApproximateDistinctFn.create(inputCoder.getValueCoder()).withPrecision(this.precision()).withSparseRepresentation(this.sparsePrecision())))).apply("Retrieve Cardinality", (PTransform)ParDo.of((DoFn)RetrieveCardinality.perKey()));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor K, @UnknownKeyFor V> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setPrecision(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setSparsePrecision(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized PerKeyDistinct<K, V> build();
        }
    }

    @AutoValue
    public static abstract class GloballyDistinct<@UnknownKeyFor InputT>
    extends PTransform<PCollection<InputT>, PCollection<Long>> {
        abstract @UnknownKeyFor @NonNull @Initialized int precision();

        abstract @UnknownKeyFor @NonNull @Initialized int sparsePrecision();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> toBuilder();

        static <InputT> @UnknownKeyFor @NonNull @Initialized Builder<InputT> builder() {
            return new AutoValue_ApproximateDistinct_GloballyDistinct.Builder().setPrecision(12).setSparsePrecision(0);
        }

        public @UnknownKeyFor @NonNull @Initialized GloballyDistinct<InputT> withPrecision(@UnknownKeyFor @NonNull @Initialized int p) {
            return this.toBuilder().setPrecision(p).build();
        }

        public @UnknownKeyFor @NonNull @Initialized GloballyDistinct<InputT> withSparsePrecision(@UnknownKeyFor @NonNull @Initialized int sp) {
            return this.toBuilder().setSparsePrecision(sp).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return (PCollection)((PCollection)input.apply("Compute HyperLogLog Structure", (PTransform)Combine.globally(ApproximateDistinctFn.create(input.getCoder()).withPrecision(this.precision()).withSparseRepresentation(this.sparsePrecision())))).apply("Retrieve Cardinality", (PTransform)ParDo.of((DoFn)RetrieveCardinality.globally()));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor InputT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setPrecision(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setSparsePrecision(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized GloballyDistinct<InputT> build();
        }
    }
}

