/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.google.auto.value.AutoValue;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.sketching.AutoValue_TDigestQuantiles_GlobalDigest;
import org.apache.beam.sdk.extensions.sketching.AutoValue_TDigestQuantiles_PerKeyDigest;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class TDigestQuantiles {
    public static @UnknownKeyFor @NonNull @Initialized GlobalDigest globally() {
        return GlobalDigest.builder().build();
    }

    public static <K> @UnknownKeyFor @NonNull @Initialized PerKeyDigest<K> perKey() {
        return PerKeyDigest.builder().build();
    }

    static class MergingDigestCoder
    extends CustomCoder<MergingDigest> {
        private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

        MergingDigestCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized MergingDigest value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null T-Digest sketch");
            }
            ByteBuffer buf = ByteBuffer.allocate(value.byteSize());
            value.asBytes(buf);
            BYTE_ARRAY_CODER.encode(buf.array(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized MergingDigest decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] bytes = BYTE_ARRAY_CODER.decode(inStream);
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            return MergingDigest.fromBytes((ByteBuffer)buf);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized MergingDigest value) {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized MergingDigest value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null T-Digest sketch");
            }
            return value.byteSize();
        }
    }

    public static class TDigestQuantilesFn
    extends Combine.CombineFn<Double, MergingDigest, MergingDigest> {
        private final @UnknownKeyFor @NonNull @Initialized double compression;

        private TDigestQuantilesFn(@UnknownKeyFor @NonNull @Initialized double compression) {
            this.compression = compression;
        }

        public static @UnknownKeyFor @NonNull @Initialized TDigestQuantilesFn create(@UnknownKeyFor @NonNull @Initialized double compression) {
            if (compression > 0.0) {
                return new TDigestQuantilesFn(compression);
            }
            throw new IllegalArgumentException("Compression factor should be greater than 0.");
        }

        public @UnknownKeyFor @NonNull @Initialized MergingDigest createAccumulator() {
            return new MergingDigest(this.compression);
        }

        public @UnknownKeyFor @NonNull @Initialized MergingDigest addInput(@UnknownKeyFor @NonNull @Initialized MergingDigest accum, @UnknownKeyFor @NonNull @Initialized Double value) {
            accum.add(value.doubleValue());
            return accum;
        }

        public @UnknownKeyFor @NonNull @Initialized MergingDigest extractOutput(@UnknownKeyFor @NonNull @Initialized MergingDigest accum) {
            return accum;
        }

        public @UnknownKeyFor @NonNull @Initialized MergingDigest mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MergingDigest> accumulators) {
            Iterator<MergingDigest> it = accumulators.iterator();
            MergingDigest merged = it.next();
            while (it.hasNext()) {
                merged.add((TDigest)it.next());
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized MergingDigest> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder inputCoder) {
            return new MergingDigestCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized MergingDigest> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder inputCoder) {
            return new MergingDigestCoder();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"compression", (Double)this.compression).withLabel("Compression factor"));
        }
    }

    @AutoValue
    public static abstract class PerKeyDigest<@UnknownKeyFor K>
    extends PTransform<PCollection<KV<K, Double>>, PCollection<KV<K, MergingDigest>>> {
        abstract @UnknownKeyFor @NonNull @Initialized double compression();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<K> toBuilder();

        static <K> @UnknownKeyFor @NonNull @Initialized Builder<K> builder() {
            return new AutoValue_TDigestQuantiles_PerKeyDigest.Builder().setCompression(100.0);
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeyDigest<K> withCompression(@UnknownKeyFor @NonNull @Initialized double cf) {
            return this.toBuilder().setCompression(cf).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized MergingDigest>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Double>> input) {
            return (PCollection)input.apply("Compute T-Digest Structure", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)TDigestQuantilesFn.create(this.compression())));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor K> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K> setCompression(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized PerKeyDigest<K> build();
        }
    }

    @AutoValue
    public static abstract class GlobalDigest
    extends PTransform<PCollection<Double>, PCollection<MergingDigest>> {
        abstract @UnknownKeyFor @NonNull @Initialized double compression();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_TDigestQuantiles_GlobalDigest.Builder().setCompression(100.0);
        }

        public @UnknownKeyFor @NonNull @Initialized GlobalDigest withCompression(@UnknownKeyFor @NonNull @Initialized double cf) {
            return this.toBuilder().setCompression(cf).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MergingDigest> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Double> input) {
            return (PCollection)input.apply("Compute T-Digest Structure", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)TDigestQuantilesFn.create(this.compression())));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized GlobalDigest build();
        }
    }
}

