/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.clearspring.analytics.stream.frequency.CountMinSketch;
import com.clearspring.analytics.stream.frequency.FrequencyMergeException;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sketching.AutoValue_SketchFrequencies_GlobalSketch;
import org.apache.beam.sdk.extensions.sketching.AutoValue_SketchFrequencies_PerKeySketch;
import org.apache.beam.sdk.extensions.sketching.AutoValue_SketchFrequencies_Sketch;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class SketchFrequencies {
    public static <InputT> @UnknownKeyFor @NonNull @Initialized GlobalSketch<InputT> globally() {
        return GlobalSketch.builder().build();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PerKeySketch<K, V> perKey() {
        return PerKeySketch.builder().build();
    }

    static class CountMinSketchCoder<@UnknownKeyFor T>
    extends CustomCoder<Sketch<T>> {
        private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

        CountMinSketchCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Sketch<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null Count-min Sketch");
            }
            BYTE_ARRAY_CODER.encode(CountMinSketch.serialize((CountMinSketch)value.sketch()), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized Sketch<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] sketchBytes = BYTE_ARRAY_CODER.decode(inStream);
            CountMinSketch sketch = CountMinSketch.deserialize((byte[])sketchBytes);
            return Sketch.create(sketch);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Sketch<T> value) {
            return true;
        }

        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Sketch<T> value) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null Count-min Sketch");
            }
            return 24L + 8L * (long)value.depth() * (long)(value.width() + 1);
        }
    }

    @AutoValue
    public static abstract class Sketch<@UnknownKeyFor T>
    implements Serializable {
        static final @UnknownKeyFor @NonNull @Initialized int SEED = 123456;

        static <T> @UnknownKeyFor @NonNull @Initialized Sketch<T> create(@UnknownKeyFor @NonNull @Initialized double eps, @UnknownKeyFor @NonNull @Initialized double conf) {
            int width = (int)Math.ceil(2.0 / eps);
            int depth = (int)Math.ceil(-Math.log(1.0 - conf) / Math.log(2.0));
            return new AutoValue_SketchFrequencies_Sketch(depth, width, new CountMinSketch(depth, width, 123456));
        }

        static <T> @UnknownKeyFor @NonNull @Initialized Sketch<T> create(@UnknownKeyFor @NonNull @Initialized CountMinSketch sketch) {
            int width = (int)Math.ceil(2.0 / sketch.getRelativeError());
            int depth = (int)Math.ceil(-Math.log(1.0 - sketch.getConfidence()) / Math.log(2.0));
            return new AutoValue_SketchFrequencies_Sketch(depth, width, sketch);
        }

        abstract @UnknownKeyFor @NonNull @Initialized int depth();

        abstract @UnknownKeyFor @NonNull @Initialized int width();

        abstract @UnknownKeyFor @NonNull @Initialized CountMinSketch sketch();

        public void add(T element, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.sketch().add(this.hashElement(element, coder), count);
        }

        public void add(T element, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.add(element, 1L, coder);
        }

        private @UnknownKeyFor @NonNull @Initialized long hashElement(T element, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            try {
                byte[] elemBytes = CoderUtils.encodeToByteArray(coder, element);
                return Hashing.murmur3_128().hashBytes(elemBytes).asLong();
            }
            catch (CoderException e) {
                throw new IllegalStateException("The input value cannot be encoded: " + e.getMessage(), e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized long estimateCount(T element, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.sketch().estimateCount(this.hashElement(element, coder));
        }
    }

    public static class CountMinSketchFn<@UnknownKeyFor InputT>
    extends Combine.CombineFn<InputT, Sketch<InputT>, Sketch<InputT>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
        private final @UnknownKeyFor @NonNull @Initialized int depth;
        private final @UnknownKeyFor @NonNull @Initialized int width;
        private final @UnknownKeyFor @NonNull @Initialized double epsilon;
        private final @UnknownKeyFor @NonNull @Initialized double confidence;

        private CountMinSketchFn(@UnknownKeyFor @NonNull @Initialized Coder<InputT> coder, @UnknownKeyFor @NonNull @Initialized double eps, @UnknownKeyFor @NonNull @Initialized double confidence) {
            this.epsilon = eps;
            this.confidence = confidence;
            this.width = (int)Math.ceil(2.0 / eps);
            this.depth = (int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0));
            this.inputCoder = coder;
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized CountMinSketchFn<InputT> create(@UnknownKeyFor @NonNull @Initialized Coder<InputT> coder) {
            try {
                coder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException("Coder must be deterministic to perform this sketch." + e.getMessage(), e);
            }
            return new CountMinSketchFn<InputT>(coder, 0.01, 0.999);
        }

        public @UnknownKeyFor @NonNull @Initialized CountMinSketchFn<InputT> withAccuracy(@UnknownKeyFor @NonNull @Initialized double epsilon, @UnknownKeyFor @NonNull @Initialized double confidence) {
            if (epsilon <= 0.0) {
                throw new IllegalArgumentException("The relative error must be positive");
            }
            if (confidence <= 0.0 || confidence >= 1.0) {
                throw new IllegalArgumentException("The confidence must be between 0 and 1");
            }
            return new CountMinSketchFn<InputT>(this.inputCoder, epsilon, confidence);
        }

        public @UnknownKeyFor @NonNull @Initialized Sketch<InputT> createAccumulator() {
            return Sketch.create(this.epsilon, this.confidence);
        }

        public @UnknownKeyFor @NonNull @Initialized Sketch<InputT> addInput(@UnknownKeyFor @NonNull @Initialized Sketch<InputT> accumulator, InputT element) {
            accumulator.add(element, this.inputCoder);
            return accumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized Sketch<InputT> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Sketch<InputT>> accumulators) {
            Iterator<Sketch<InputT>> it = accumulators.iterator();
            Sketch<InputT> first = it.next();
            CountMinSketch mergedSketches = first.sketch();
            try {
                while (it.hasNext()) {
                    mergedSketches = CountMinSketch.merge((CountMinSketch[])new CountMinSketch[]{mergedSketches, it.next().sketch()});
                }
            }
            catch (FrequencyMergeException e) {
                throw new IllegalStateException("The accumulators cannot be merged:" + e.getMessage());
            }
            return Sketch.create(mergedSketches);
        }

        public @UnknownKeyFor @NonNull @Initialized Sketch<InputT> extractOutput(@UnknownKeyFor @NonNull @Initialized Sketch<InputT> accumulator) {
            return accumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Sketch<InputT>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder inputCoder) {
            return new CountMinSketchCoder();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"width", (Integer)this.width).withLabel("width of the Count-Min sketch array")).add(DisplayData.item((String)"depth", (Integer)this.depth).withLabel("depth of the Count-Min sketch array")).add(DisplayData.item((String)"eps", (Double)this.epsilon).withLabel("relative error to the total number of elements")).add(DisplayData.item((String)"conf", (Double)this.confidence).withLabel("confidence in the relative error"));
        }
    }

    @AutoValue
    public static abstract class PerKeySketch<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Sketch<V>>>> {
        abstract @UnknownKeyFor @NonNull @Initialized double relativeError();

        abstract @UnknownKeyFor @NonNull @Initialized double confidence();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> toBuilder();

        static <K, V> @UnknownKeyFor @NonNull @Initialized Builder<K, V> builder() {
            return new AutoValue_SketchFrequencies_PerKeySketch.Builder().setRelativeError(0.01).setConfidence(0.999);
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeySketch<K, V> withRelativeError(@UnknownKeyFor @NonNull @Initialized double eps) {
            return this.toBuilder().setRelativeError(eps).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PerKeySketch<K, V> withConfidence(@UnknownKeyFor @NonNull @Initialized double conf) {
            return this.toBuilder().setConfidence(conf).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Sketch<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return (PCollection)input.apply("Compute Count-Min Sketch perKey", (PTransform)Combine.perKey(CountMinSketchFn.create(inputCoder.getValueCoder()).withAccuracy(this.relativeError(), this.confidence())));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor K, @UnknownKeyFor V> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setRelativeError(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<K, V> setConfidence(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized PerKeySketch<K, V> build();
        }
    }

    @AutoValue
    public static abstract class GlobalSketch<@UnknownKeyFor InputT>
    extends PTransform<PCollection<InputT>, PCollection<Sketch<InputT>>> {
        abstract @UnknownKeyFor @NonNull @Initialized double relativeError();

        abstract @UnknownKeyFor @NonNull @Initialized double confidence();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> toBuilder();

        static <InputT> @UnknownKeyFor @NonNull @Initialized Builder<InputT> builder() {
            return new AutoValue_SketchFrequencies_GlobalSketch.Builder().setRelativeError(0.01).setConfidence(0.999);
        }

        public @UnknownKeyFor @NonNull @Initialized GlobalSketch<InputT> withRelativeError(@UnknownKeyFor @NonNull @Initialized double eps) {
            return this.toBuilder().setRelativeError(eps).build();
        }

        public @UnknownKeyFor @NonNull @Initialized GlobalSketch<InputT> withConfidence(@UnknownKeyFor @NonNull @Initialized double conf) {
            return this.toBuilder().setConfidence(conf).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Sketch<InputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return (PCollection)input.apply("Compute Count-Min Sketch", (PTransform)Combine.globally(CountMinSketchFn.create(input.getCoder()).withAccuracy(this.relativeError(), this.confidence())));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor InputT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setRelativeError(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT> setConfidence(@UnknownKeyFor @NonNull @Initialized double var1);

            abstract @UnknownKeyFor @NonNull @Initialized GlobalSketch<InputT> build();
        }
    }
}

