/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.google.auto.value.AutoValue;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.sketching.AutoValue_TDigestQuantiles_GlobalDigest;
import org.apache.beam.sdk.extensions.sketching.AutoValue_TDigestQuantiles_PerKeyDigest;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

@Experimental
public final class TDigestQuantiles {
    public static GlobalDigest globally() {
        return GlobalDigest.builder().build();
    }

    public static <K> PerKeyDigest<K> perKey() {
        return PerKeyDigest.builder().build();
    }

    static class MergingDigestCoder
    extends CustomCoder<MergingDigest> {
        private static final ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

        MergingDigestCoder() {
        }

        public void encode(MergingDigest value, OutputStream outStream) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null T-Digest sketch");
            }
            ByteBuffer buf = ByteBuffer.allocate(value.byteSize());
            value.asBytes(buf);
            BYTE_ARRAY_CODER.encode(buf.array(), outStream);
        }

        public MergingDigest decode(InputStream inStream) throws IOException {
            byte[] bytes = BYTE_ARRAY_CODER.decode(inStream);
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            return MergingDigest.fromBytes((ByteBuffer)buf);
        }

        public boolean isRegisterByteSizeObserverCheap(MergingDigest value) {
            return true;
        }

        protected long getEncodedElementByteSize(MergingDigest value) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null T-Digest sketch");
            }
            return value.byteSize();
        }
    }

    public static class TDigestQuantilesFn
    extends Combine.CombineFn<Double, MergingDigest, MergingDigest> {
        private final double compression;

        private TDigestQuantilesFn(double compression) {
            this.compression = compression;
        }

        public static TDigestQuantilesFn create(double compression) {
            if (compression > 0.0) {
                return new TDigestQuantilesFn(compression);
            }
            throw new IllegalArgumentException("Compression factor should be greater than 0.");
        }

        public MergingDigest createAccumulator() {
            return new MergingDigest(this.compression);
        }

        public MergingDigest addInput(MergingDigest accum, Double value) {
            accum.add(value.doubleValue());
            return accum;
        }

        public MergingDigest extractOutput(MergingDigest accum) {
            return accum;
        }

        public MergingDigest mergeAccumulators(Iterable<MergingDigest> accumulators) {
            Iterator<MergingDigest> it = accumulators.iterator();
            MergingDigest merged = it.next();
            while (it.hasNext()) {
                merged.add((TDigest)it.next());
            }
            return merged;
        }

        public Coder<MergingDigest> getAccumulatorCoder(CoderRegistry registry, Coder inputCoder) {
            return new MergingDigestCoder();
        }

        public Coder<MergingDigest> getDefaultOutputCoder(CoderRegistry registry, Coder inputCoder) {
            return new MergingDigestCoder();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"compression", (Double)this.compression).withLabel("Compression factor"));
        }
    }

    @AutoValue
    public static abstract class PerKeyDigest<K>
    extends PTransform<PCollection<KV<K, Double>>, PCollection<KV<K, MergingDigest>>> {
        abstract double compression();

        abstract Builder<K> toBuilder();

        static <K> Builder<K> builder() {
            return new AutoValue_TDigestQuantiles_PerKeyDigest.Builder().setCompression(100.0);
        }

        public PerKeyDigest<K> withCompression(double cf) {
            return this.toBuilder().setCompression(cf).build();
        }

        public PCollection<KV<K, MergingDigest>> expand(PCollection<KV<K, Double>> input) {
            return (PCollection)input.apply("Compute T-Digest Structure", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)TDigestQuantilesFn.create(this.compression())));
        }

        @AutoValue.Builder
        static abstract class Builder<K> {
            Builder() {
            }

            abstract Builder<K> setCompression(double var1);

            abstract PerKeyDigest<K> build();
        }
    }

    @AutoValue
    public static abstract class GlobalDigest
    extends PTransform<PCollection<Double>, PCollection<MergingDigest>> {
        abstract double compression();

        abstract Builder toBuilder();

        static Builder builder() {
            return new AutoValue_TDigestQuantiles_GlobalDigest.Builder().setCompression(100.0);
        }

        public GlobalDigest withCompression(double cf) {
            return this.toBuilder().setCompression(cf).build();
        }

        public PCollection<MergingDigest> expand(PCollection<Double> input) {
            return (PCollection)input.apply("Compute T-Digest Structure", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)TDigestQuantilesFn.create(this.compression())));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setCompression(double var1);

            abstract GlobalDigest build();
        }
    }
}

