/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.MergingDigest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sketching.TDigestQuantiles;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TDigestQuantilesTest {
    @Rule
    public final transient TestPipeline tp = TestPipeline.create();
    private static final List<Double> stream = TDigestQuantilesTest.generateStream();
    private static final int size = 999;
    private static final int compression = 100;
    private static final double[] quantiles = new double[]{0.25, 0.5, 0.75, 0.99};
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static List<Double> generateStream() {
        ArrayList<Double> li = new ArrayList<Double>();
        for (double i = 1.0; i <= 999.0; i += 1.0) {
            li.add(i);
        }
        Collections.shuffle(li);
        return li;
    }

    @Test
    public void globally() {
        PCollection col = (PCollection)((PCollection)((PCollection)this.tp.apply((PTransform)Create.of(stream))).apply((PTransform)TDigestQuantiles.globally().withCompression(100.0))).apply((PTransform)ParDo.of((DoFn)new RetrieveQuantiles(quantiles)));
        PAssert.that((String)"Verify Accuracy", (PCollection)col).satisfies((SerializableFunction)new VerifyAccuracy());
        this.tp.run();
    }

    @Test
    public void perKey() {
        PCollection col = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.tp.apply((PTransform)Create.of(stream))).apply((PTransform)WithKeys.of((Object)1))).apply((PTransform)TDigestQuantiles.perKey().withCompression(100.0))).apply((PTransform)Values.create())).apply((PTransform)ParDo.of((DoFn)new RetrieveQuantiles(quantiles)));
        PAssert.that((String)"Verify Accuracy", (PCollection)col).satisfies((SerializableFunction)new VerifyAccuracy());
        this.tp.run();
    }

    @Test
    public void testCoder() throws Exception {
        MergingDigest tDigest = new MergingDigest(1000.0);
        for (int i = 0; i < 10; ++i) {
            tDigest.add(2.4 + (double)i);
        }
        Assert.assertTrue((String)"Encode and Decode", (boolean)this.encodeDecodeEquals(tDigest));
    }

    @Test
    public void testMergeAccum() {
        Random rd = new Random(1234L);
        ArrayList<MergingDigest> accums = new ArrayList<MergingDigest>();
        for (int i = 0; i < 3; ++i) {
            MergingDigest std = new MergingDigest(100.0);
            for (int j = 0; j < 1000; ++j) {
                std.add(rd.nextDouble());
            }
            accums.add(std);
        }
        TDigestQuantiles.TDigestQuantilesFn fn = TDigestQuantiles.TDigestQuantilesFn.create((double)100.0);
        MergingDigest res = fn.mergeAccumulators(accums);
    }

    private <T> boolean encodeDecodeEquals(MergingDigest tDigest) throws IOException {
        MergingDigest decoded = (MergingDigest)CoderUtils.clone((Coder)new TDigestQuantiles.MergingDigestCoder(), (Object)tDigest);
        boolean equal = true;
        Iterator it1 = decoded.centroids().iterator();
        Iterator it2 = tDigest.centroids().iterator();
        for (int i = 0; i < decoded.centroids().size(); ++i) {
            Centroid c1 = (Centroid)it1.next();
            Centroid c2 = (Centroid)it2.next();
            if ((float)c1.mean() == (float)c2.mean() && c1.count() == c2.count()) continue;
            equal = false;
            break;
        }
        return equal;
    }

    @Test
    public void testDisplayData() {
        TDigestQuantiles.TDigestQuantilesFn fn = TDigestQuantiles.TDigestQuantilesFn.create((double)155.0);
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)fn), (Matcher)DisplayDataMatchers.hasDisplayItem((String)"compression", (double)155.0));
    }

    static class VerifyAccuracy
    implements SerializableFunction<Iterable<KV<Double, Double>>, Void> {
        final double expectedError = 0.03;

        VerifyAccuracy() {
        }

        public Void apply(Iterable<KV<Double, Double>> input) {
            for (KV<Double, Double> pair : input) {
                double expectedValue = (Double)pair.getKey() * 1000.0;
                boolean isAccurate = Math.abs((Double)pair.getValue() - expectedValue) / 999.0 <= 0.03;
                Assert.assertTrue((String)("not accurate enough : \nQuantile " + pair.getKey() + " is " + pair.getValue() + " and not " + expectedValue), (boolean)isAccurate);
            }
            return null;
        }
    }

    static class RetrieveQuantiles
    extends DoFn<MergingDigest, KV<Double, Double>> {
        private final double[] quantiles;

        RetrieveQuantiles(double[] quantiles) {
            this.quantiles = quantiles;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            for (double q : this.quantiles) {
                c.output((Object)KV.of((Object)q, (Object)((MergingDigest)c.element()).quantile(q)));
            }
        }
    }
}

