/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sketching;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sketching.ApproximateDistinct;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApproximateDistinctTest
implements Serializable {
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestPipeline tp = TestPipeline.create();

    @Test
    public void smallCardinality() {
        int smallCard = 1000;
        int p = 6;
        double expectedErr = 1.104 / Math.sqrt(6.0);
        ArrayList<Integer> small = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            small.add(i);
        }
        PCollection cardinality = (PCollection)((PCollection)this.tp.apply("small stream", (PTransform)Create.of(small))).apply("small cardinality", (PTransform)ApproximateDistinct.globally().withPrecision(6));
        PAssert.that((String)"Not Accurate Enough", (PCollection)cardinality).satisfies((SerializableFunction)new VerifyAccuracy(1000, expectedErr));
        this.tp.run();
    }

    @Test
    public void bigCardinality() {
        int cardinality = 15000;
        int p = 15;
        int sp = 20;
        double expectedErr = 1.04 / Math.sqrt(15.0);
        ArrayList<Integer> stream = new ArrayList<Integer>();
        for (int i = 1; i <= 15000; ++i) {
            stream.addAll(Collections.nCopies(2, i));
        }
        Collections.shuffle(stream);
        PCollection res = (PCollection)((PCollection)this.tp.apply("big stream", (PTransform)Create.of(stream))).apply("big cardinality", (PTransform)ApproximateDistinct.globally().withPrecision(15).withSparsePrecision(20));
        PAssert.that((String)"Verify Accuracy for big cardinality", (PCollection)res).satisfies((SerializableFunction)new VerifyAccuracy(15000, expectedErr));
        this.tp.run();
    }

    @Test
    public void perKey() {
        int cardinality = 1000;
        int p = 15;
        double expectedErr = 1.04 / Math.sqrt(15.0);
        ArrayList<Integer> stream = new ArrayList<Integer>();
        for (int i = 1; i <= 1000; ++i) {
            stream.addAll(Collections.nCopies(2, i));
        }
        Collections.shuffle(stream);
        PCollection results = (PCollection)((PCollection)((PCollection)((PCollection)this.tp.apply("per key stream", (PTransform)Create.of(stream))).apply("create keys", (PTransform)WithKeys.of((Object)1))).apply("per key cardinality", (PTransform)ApproximateDistinct.perKey().withPrecision(15))).apply("extract values", (PTransform)Values.create());
        PAssert.that((String)"Verify Accuracy for cardinality per key", (PCollection)results).satisfies((SerializableFunction)new VerifyAccuracy(1000, expectedErr));
        this.tp.run();
    }

    @Test
    public void customObject() {
        int cardinality = 500;
        int p = 15;
        double expectedErr = 1.04 / Math.sqrt(15.0);
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().requiredString("Pseudo").requiredInt("Age").endRecord();
        ArrayList<GenericData.Record> users = new ArrayList<GenericData.Record>();
        for (int i = 1; i <= 500; ++i) {
            GenericData.Record newRecord = new GenericData.Record(schema);
            newRecord.put("Pseudo", (Object)("User" + i));
            newRecord.put("Age", (Object)i);
            users.add(newRecord);
        }
        PCollection results = (PCollection)((PCollection)this.tp.apply("Create stream", (PTransform)Create.of(users).withCoder((Coder)AvroCoder.of((Schema)schema)))).apply("Test custom object", (PTransform)ApproximateDistinct.globally().withPrecision(15));
        PAssert.that((String)"Verify Accuracy for custom object", (PCollection)results).satisfies((SerializableFunction)new VerifyAccuracy(500, expectedErr));
        this.tp.run();
    }

    @Test
    public void testCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
        HyperLogLogPlus hllp = new HyperLogLogPlus(12, 18);
        for (int i = 0; i < 10; ++i) {
            hllp.offer((Object)i);
        }
        CoderProperties.coderDecodeEncodeEqual((Coder)ApproximateDistinct.HyperLogLogPlusCoder.of(), (Object)hllp);
    }

    @Test
    public void testDisplayData() {
        ApproximateDistinct.ApproximateDistinctFn fnWithPrecision = ApproximateDistinct.ApproximateDistinctFn.create((Coder)BigEndianIntegerCoder.of()).withPrecision(23);
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)fnWithPrecision), (Matcher)DisplayDataMatchers.hasDisplayItem((String)"p", (long)23L));
        MatcherAssert.assertThat((Object)DisplayData.from((HasDisplayData)fnWithPrecision), (Matcher)DisplayDataMatchers.hasDisplayItem((String)"sp", (long)0L));
    }

    private static class VerifyAccuracy
    implements SerializableFunction<Iterable<Long>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized int expectedCard;
        private final @UnknownKeyFor @NonNull @Initialized double expectedError;

        VerifyAccuracy(@UnknownKeyFor @NonNull @Initialized int expectedCard, @UnknownKeyFor @NonNull @Initialized double expectedError) {
            this.expectedCard = expectedCard;
            this.expectedError = expectedError;
        }

        public @UnknownKeyFor @Nullable @Initialized Void apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Long> input) {
            for (Long estimate : input) {
                boolean isAccurate = (double)(Math.abs(estimate - (long)this.expectedCard) / (long)this.expectedCard) < this.expectedError;
                Assert.assertTrue((String)("not accurate enough : \nExpected Cardinality : " + this.expectedCard + "\nComputed Cardinality : " + estimate), (boolean)isAccurate);
            }
            return null;
        }
    }
}

