/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import org.apache.beam.runners.core.construction.BaseExternalTest;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.python.transforms.PythonMap;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.UsesPythonExpansionService;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PythonMapTest
extends BaseExternalTest {
    @Test
    @Category(value={ValidatesRunner.class, UsesPythonExpansionService.class})
    public void testPythonMap() {
        PCollection output = (PCollection)((PCollection)this.testPipeline.apply("CreateData", (PTransform)Create.of((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d")))).apply("ApplyPythonMap", (PTransform)PythonMap.viaMapFn((String)"lambda x:3*x", (Coder)StringUtf8Coder.of()).withExpansionService(expansionAddr));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"aaa", "bbb", "ccc", "ddd"});
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesPythonExpansionService.class})
    public void testPythonFlatMap() {
        PCollection output = (PCollection)((PCollection)this.testPipeline.apply("CreateData", (PTransform)Create.of((Iterable)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")))).apply("ApplyPythonFlatMap", (PTransform)PythonMap.viaFlatMapFn((String)"lambda x:[2*x, 3*x, 4*x]", (Coder)StringUtf8Coder.of()).withExpansionService(expansionAddr));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"aa", "aaa", "aaaa", "bb", "bbb", "bbbb", "cc", "ccc", "cccc"});
    }
}

