/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import org.apache.beam.runners.core.construction.BaseExternalTest;
import org.apache.beam.sdk.extensions.python.transforms.DataframeTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.UsesPythonExpansionService;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataframeTransformTest
extends BaseExternalTest {
    @Test
    @Category(value={ValidatesRunner.class, UsesPythonExpansionService.class})
    public void testDataframeSum() {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"a", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.of((String)"b", (Schema.FieldType)Schema.FieldType.INT32)});
        Row foo1 = Row.withSchema((Schema)schema).withFieldValue("a", (Object)100L).withFieldValue("b", (Object)1).build();
        Row foo2 = Row.withSchema((Schema)schema).withFieldValue("a", (Object)100L).withFieldValue("b", (Object)2).build();
        Row foo3 = Row.withSchema((Schema)schema).withFieldValue("a", (Object)100L).withFieldValue("b", (Object)3).build();
        Row bar4 = Row.withSchema((Schema)schema).withFieldValue("a", (Object)200L).withFieldValue("b", (Object)4).build();
        PCollection col = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)foo1, (Object[])new Row[]{foo2, bar4}))).setRowSchema(schema).apply((PTransform)DataframeTransform.of((String)"lambda df: df.groupby('a').sum()").withIndexes().withExpansionService(expansionAddr));
        PAssert.that((PCollection)col).containsInAnyOrder((Object[])new Row[]{foo3, bar4});
    }
}

